/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.transaction.DataType;

public class DoubleIndex
extends AbstractBufferIndex<Double, NumericFilter> {
    public static final int ENTRY_SIZE = 8;

    public DoubleIndex(String name, TableIndex table) {
        super(name, table, FullTextIndexingOptions.NOT_INDEXED);
    }

    @Override
    protected int getEntrySize() {
        return 8;
    }

    @Override
    public IndexType getType() {
        return IndexType.DOUBLE;
    }

    @Override
    public Double getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Double value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0.0);
    }

    public double getValue(int id) {
        if (id > this.getMaximumId()) {
            return 0.0;
        }
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 8;
        return this.getBuffer(index).getDouble(position, ByteOrder.LITTLE_ENDIAN);
    }

    public void setValue(int id, double value) {
        this.ensureBufferSize(id);
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 8;
        this.getBuffer(index).putDouble(position, value, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            double value1 = this.getValue(o1.getLeafId());
            double value2 = this.getValue(o2.getLeafId());
            return Double.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Double> set = new HashSet<Double>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.doubleValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().doubleValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().doubleValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().doubleValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().doubleValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().doubleValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().doubleValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().doubleValue(), numericFilter.getValue2().doubleValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().doubleValue(), numericFilter.getValue2().doubleValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    @Override
    public void writeTransactionValue(Double value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.DOUBLE.getId());
        dataOutputStream.writeDouble(value);
    }

    @Override
    public Double readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readDouble();
    }

    public BitSet filterEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, double compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, double start, double end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, double start, double end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Double> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Double> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            double value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

