/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.transaction.DataType;

public class FloatIndex
extends AbstractBufferIndex<Float, NumericFilter> {
    public static final int ENTRY_SIZE = 4;

    public FloatIndex(String name, TableIndex table) {
        super(name, table, FullTextIndexingOptions.NOT_INDEXED);
    }

    @Override
    protected int getEntrySize() {
        return 4;
    }

    @Override
    public IndexType getType() {
        return IndexType.FLOAT;
    }

    @Override
    public Float getGenericValue(int id) {
        return Float.valueOf(this.getValue(id));
    }

    @Override
    public void setGenericValue(int id, Float value) {
        this.setValue(id, value.floatValue());
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0.0f);
    }

    public float getValue(int id) {
        if (id > this.getMaximumId()) {
            return 0.0f;
        }
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 4;
        return this.getBuffer(index).getFloat(position, ByteOrder.LITTLE_ENDIAN);
    }

    public void setValue(int id, float value) {
        this.ensureBufferSize(id);
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 4;
        this.getBuffer(index).putFloat(position, value, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeTransactionValue(Float value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.FLOAT.getId());
        dataOutputStream.writeFloat(value.floatValue());
    }

    @Override
    public Float readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return Float.valueOf(dataInputStream.readFloat());
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            float value1 = this.getValue(o1.getLeafId());
            float value2 = this.getValue(o2.getLeafId());
            return Float.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Float> set = new HashSet<Float>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(Float.valueOf(value.floatValue()));
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().floatValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().floatValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().floatValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().floatValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().floatValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().floatValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().floatValue(), numericFilter.getValue2().floatValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().floatValue(), numericFilter.getValue2().floatValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, float compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, float start, float end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, float start, float end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Float> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (set.contains(Float.valueOf(value))) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Float> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            float value = this.getValue(id);
            if (!set.contains(Float.valueOf(value))) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

