/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.transaction.DataType;

public class ShortIndex
extends AbstractBufferIndex<Short, NumericFilter> {
    public static final int ENTRY_SIZE = 2;

    public ShortIndex(String name, TableIndex tableIndex) {
        super(name, tableIndex, FullTextIndexingOptions.NOT_INDEXED);
    }

    @Override
    protected int getEntrySize() {
        return 2;
    }

    @Override
    public IndexType getType() {
        return IndexType.SHORT;
    }

    @Override
    public Short getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Short value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, (short)0);
    }

    public short getValue(int id) {
        if (id > this.getMaximumId()) {
            return 0;
        }
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 2;
        return this.getBuffer(index).getShort(position, ByteOrder.LITTLE_ENDIAN);
    }

    public void setValue(int id, short value) {
        this.ensureBufferSize(id);
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 2;
        this.getBuffer(index).putShort(position, value, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeTransactionValue(Short value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.SHORT.getId());
        dataOutputStream.writeShort(value.shortValue());
    }

    @Override
    public Short readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            short value1 = this.getValue(o1.getLeafId());
            short value2 = this.getValue(o2.getLeafId());
            return Short.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Short> set = new HashSet<Short>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.shortValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().shortValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().shortValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().shortValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().shortValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().shortValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().shortValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().shortValue(), numericFilter.getValue2().shortValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().shortValue(), numericFilter.getValue2().shortValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, short compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, short start, short end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, short start, short end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Short> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Short> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            short value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

