/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.teamapps.universaldb.index.file.FileUtil;
import org.teamapps.universaldb.index.text.SearchCollector;
import org.teamapps.universaldb.index.text.SearchIndexUtil;
import org.teamapps.universaldb.index.text.TextFilter;

public class TextSearchIndex {
    public static final String VALUE = "value";
    public static final String ID = "id";
    private File dir;
    private StringField idSearchField;
    private NumericDocValuesField idField;
    private Field valueField;
    private IndexWriter writer;
    private Analyzer queryAnalyzer;

    public TextSearchIndex(File path, String name) {
        try {
            this.dir = new File(path, name);
            FSDirectory directory = FSDirectory.open((Path)this.dir.toPath());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            this.queryAnalyzer = new StandardAnalyzer();
            IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            iwc.setRAMBufferSizeMB(12.0);
            this.writer = new IndexWriter((Directory)directory, iwc);
            this.idSearchField = new StringField(ID, "", Field.Store.NO);
            this.idField = new NumericDocValuesField(ID, 0L);
            this.valueField = new Field(VALUE, (CharSequence)"", (IndexableFieldType)SearchIndexUtil.createIndexFieldType());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.writer != null && this.writer.isOpen()) {
                    try {
                        this.writer.commit();
                        this.writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addValue(int id, String value, boolean update) {
        try {
            this.idSearchField.setStringValue("" + id);
            this.idField.setLongValue((long)id);
            this.valueField.setStringValue(value);
            Document doc = new Document();
            doc.add((IndexableField)this.idSearchField);
            doc.add((IndexableField)this.idField);
            doc.add((IndexableField)this.valueField);
            if (update) {
                Term term = new Term(ID, "" + id);
                this.writer.updateDocument(term, (Iterable)doc);
            } else {
                this.writer.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeValue(int id) {
        try {
            Term term = new Term(ID, "" + id);
            this.writer.deleteDocuments(new Term[]{term});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BitSet filter(BitSet bitSet, TextFilter textFilter) {
        try {
            if (textFilter == null) {
                return bitSet;
            }
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer, (boolean)false, (boolean)false);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            SearchCollector collector = new SearchCollector();
            Query query = SearchIndexUtil.createQuery(textFilter.getFilterType(), VALUE, textFilter.getValue(), this.queryAnalyzer);
            searcher.search(query, (Collector)collector);
            BitSet resultIds = collector.getResultIds();
            resultIds.and(bitSet);
            return resultIds;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void commit(boolean close) {
        try {
            if (this.writer != null && this.writer.isOpen()) {
                this.writer.commit();
                if (close) {
                    this.writer.close();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void drop() {
        this.commit(true);
        FileUtil.deleteFileRecursive(this.dir);
    }
}

