/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.universaldb.schema.Table;
import org.teamapps.universaldb.util.DataStreamUtil;

public class Schema
implements SchemaInfoProvider {
    private final int schemaVersion = 1;
    private String pojoNamespace = "org.teamapps.datamodel";
    private final List<Database> databases = new ArrayList<Database>();

    public static Schema create() {
        return new Schema();
    }

    public static Schema create(String pojoNamespace) {
        return new Schema(pojoNamespace);
    }

    public static Schema parse(String schemaData) {
        return new Schema(schemaData);
    }

    public static void checkName(String name) {
        if (name == null || name.isEmpty() || !name.chars().allMatch(Character::isLetterOrDigit)) {
            throw new RuntimeException("ERROR: INVALID NAME:" + name);
        }
    }

    public static void checkColumnName(String name) {
        Schema.checkName(name);
        if (Table.isReservedMetaName(name)) {
            throw new RuntimeException("ERROR: FORBIDDEN COLUMN NAME:" + name);
        }
    }

    private static List<String> getTokens(String line) {
        line = line.trim();
        String[] parts = line.split(" ");
        return Arrays.asList(parts);
    }

    public Schema() {
    }

    public Schema(String schemaData) {
        String[] lines = schemaData.split("\n");
        boolean foundSchema = false;
        Database db = null;
        Table table = null;
        Set<String> columnTypes = ColumnType.getNames();
        HashMap<Column, String> unresolvedReferenceTableMap = new HashMap<Column, String>();
        for (String line : lines) {
            List<String> tokens;
            if (line.startsWith("/") || line.startsWith("#") || (tokens = Schema.getTokens(line)).size() < 3 || !tokens.get(1).equalsIgnoreCase("as")) continue;
            String name = tokens.get(0);
            String type = tokens.get(2);
            if (type.equalsIgnoreCase("SCHEMA")) {
                foundSchema = true;
                this.setPojoNamespace(name);
            }
            if (!foundSchema) continue;
            if (type.equalsIgnoreCase("DATABASE")) {
                db = this.addDatabase(name);
            }
            if (type.equalsIgnoreCase("TABLE")) {
                TableConfig tableConfig = TableConfig.parse(line);
                table = db.addTable(name, tableConfig.getTableOptions());
            }
            if (!columnTypes.contains(type.toUpperCase()) || Table.isReservedMetaName(name)) continue;
            ColumnType columnType = ColumnType.valueOf(type);
            Column column = table.addColumn(name, columnType);
            if (columnType.isReference()) {
                unresolvedReferenceTableMap.put(column, tokens.get(3));
                String backReference = tokens.get(5);
                column.setBackReference(backReference.equals("NONE") ? null : backReference);
                continue;
            }
            if (columnType != ColumnType.ENUM) continue;
            line = line.trim();
            String[] values = line.substring(line.indexOf("VALUES (") + 8).replace(")", "").split(", ");
            column.setEnumValues(Arrays.asList(values));
        }
        for (Map.Entry entry : unresolvedReferenceTableMap.entrySet()) {
            Column column = (Column)entry.getKey();
            String fullName = (String)entry.getValue();
            String[] parts = fullName.split("\\.");
            String dbName = parts[0];
            String tableName = parts[1];
            Database refDb = this.getDatabases().stream().filter(database -> database.getName().equals(dbName)).findAny().orElse(null);
            Table referenceTable = refDb.getTables().stream().filter(refTable -> refTable.getName().equals(tableName)).findAny().orElse(null);
            column.setReferencedTable(referenceTable);
        }
    }

    public Schema(byte[] data) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(data)));
    }

    public Schema(DataInputStream dataInputStream) throws IOException {
        this(new String(DataStreamUtil.readByteArrayWithLengthHeader(dataInputStream), StandardCharsets.UTF_8));
    }

    public byte[] getSchemaData() {
        String schema = this.getSchema();
        return schema.getBytes(StandardCharsets.UTF_8);
    }

    public void writeSchema(DataOutputStream dataOutputStream) throws IOException {
        byte[] schemaData = this.getSchemaData();
        DataStreamUtil.writeByteArrayWithLengthHeader(dataOutputStream, schemaData);
    }

    public String createDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pojoNamespace).append(" as SCHEMA").append("\n");
        this.databases.forEach(db -> sb.append(db.createDefinition()));
        return sb.toString();
    }

    public List<Database> getDatabases() {
        return this.databases;
    }

    public Database addDatabase(String name) {
        Schema.checkName(name);
        return this.addDatabase(new Database(this, name));
    }

    private Database addDatabase(Database dataBase) {
        this.databases.add(dataBase);
        return dataBase;
    }

    public String getPojoNamespace() {
        return this.pojoNamespace;
    }

    public void setPojoNamespace(String pojoNamespace) {
        this.pojoNamespace = pojoNamespace;
    }

    public int getSchemaVersion() {
        return 1;
    }

    public boolean isCompatibleWith(Schema schema) {
        if (this.schemaVersion != schema.getSchemaVersion()) {
            return false;
        }
        Map<String, Database> databaseMap = this.databases.stream().collect(Collectors.toMap(Database::getName, db -> db));
        for (Database database : schema.getDatabases()) {
            Database localDatabase = databaseMap.get(database.getName());
            if (localDatabase != null) {
                if (localDatabase.getMappingId() > 0 && database.getMappingId() > 0 && localDatabase.getMappingId() != database.getMappingId()) {
                    return false;
                }
                boolean compatibleWith = localDatabase.isCompatibleWith(database);
                if (compatibleWith) continue;
                return false;
            }
            if (database.getMappingId() == 0 || !this.getMappingIds().contains(database.getMappingId())) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSchema(Schema schema) throws IOException {
        byte[] schemaData = this.getSchemaData();
        byte[] schemaData2 = schema.getSchemaData();
        return Arrays.equals(schemaData, schemaData2);
    }

    public void merge(Schema schema) {
        if (!this.isCompatibleWith(schema)) {
            throw new RuntimeException("Error: cannot merge incompatible schemas:" + this + " with " + schema);
        }
        Map<String, Database> databaseMap = this.databases.stream().collect(Collectors.toMap(Database::getName, db -> db));
        for (Database database : schema.getDatabases()) {
            Database localDatabase = databaseMap.get(database.getName());
            if (localDatabase == null) {
                this.addDatabase(database);
                continue;
            }
            if (localDatabase.getMappingId() == 0) {
                localDatabase.setMappingId(database.getMappingId());
            }
            localDatabase.merge(database);
        }
    }

    public void mapSchema() {
        for (Database database : this.databases) {
            if (database.getMappingId() == 0) {
                database.setMappingId(this.getNextMappingId());
            }
            for (Table table : database.getTables()) {
                if (table.getMappingId() == 0) {
                    table.setMappingId(this.getNextMappingId());
                }
                for (Column column : table.getColumns()) {
                    if (column.getMappingId() != 0) continue;
                    column.setMappingId(this.getNextMappingId());
                }
            }
        }
    }

    private int getNextMappingId() {
        Set<Integer> mappingIds = this.getMappingIds();
        int mappingId = mappingIds.size() + 1;
        while (mappingIds.contains(mappingId)) {
            ++mappingId;
        }
        return mappingId;
    }

    public Set<Integer> getMappingIds() {
        HashSet<Integer> mappingIds = new HashSet<Integer>();
        for (Database database : this.databases) {
            mappingIds.add(database.getMappingId());
            for (Table table : database.getTables()) {
                mappingIds.add(table.getMappingId());
                for (Column column : table.getColumns()) {
                    mappingIds.add(column.getMappingId());
                }
            }
        }
        mappingIds.remove(0);
        return mappingIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Schema, version:").append(1).append("\n");
        for (Database database : this.databases) {
            sb.append(database.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getSchema() {
        return this.createDefinition();
    }
}

