/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionPacket {
    private final long transactionRequestId;
    private final long timestamp;
    private final int userId;
    private byte[] transactionData;
    private long transactionId;
    private byte[] correlationData;

    public TransactionPacket(long transactionRequestId, long transactionId, long timestamp, int userId) {
        this.transactionRequestId = transactionRequestId;
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.userId = userId;
    }

    public TransactionPacket(byte[] bytes) throws IOException {
        this(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public TransactionPacket(DataInputStream dataInputStream) throws IOException {
        this.transactionRequestId = dataInputStream.readLong();
        this.transactionId = dataInputStream.readLong();
        this.timestamp = dataInputStream.readLong();
        this.userId = dataInputStream.readInt();
        int transactionDataLength = dataInputStream.readInt();
        this.transactionData = new byte[transactionDataLength];
        dataInputStream.readFully(this.transactionData);
        int correlationDataLength = dataInputStream.readInt();
        if (correlationDataLength > 0) {
            this.correlationData = new byte[correlationDataLength];
            dataInputStream.readFully(this.correlationData);
        }
    }

    public long getTransactionRequestId() {
        return this.transactionRequestId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getUserId() {
        return this.userId;
    }

    public byte[] getTransactionData() {
        return this.transactionData;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public void setTransactionData(byte[] transactionData) {
        this.transactionData = transactionData;
    }

    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    public void setCorrelationData(byte[] correlationData) {
        this.correlationData = correlationData;
    }

    public int getPacketLengthWithAllHeaders() {
        int length = 24 + this.transactionData.length;
        if (this.correlationData != null) {
            length += this.correlationData.length;
        }
        return length;
    }

    public void writePacket(DataOutputStream outputStream) throws IOException {
        outputStream.writeLong(this.transactionRequestId);
        outputStream.writeLong(this.transactionId);
        outputStream.writeLong(this.timestamp);
        outputStream.writeInt(this.userId);
        outputStream.writeInt(this.transactionData.length);
        outputStream.write(this.transactionData);
        if (this.correlationData != null) {
            outputStream.writeInt(this.correlationData.length);
            outputStream.write(this.correlationData);
        } else {
            outputStream.writeInt(0);
        }
    }

    public byte[] writePacketBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.getPacketLengthWithAllHeaders() + 4);
        this.writePacket(new DataOutputStream(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }
}

