/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BitSetBooleanIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;
import org.teamapps.universaldb.util.DataStreamUtil;

public interface ColumnIndex<TYPE, FILTER>
extends MappedObject {
    public static ColumnIndex createColumn(TableIndex table, String name, IndexType indexType) {
        AbstractIndex column = null;
        switch (indexType) {
            case BOOLEAN: {
                column = new BitSetBooleanIndex(name, table);
                break;
            }
            case SHORT: {
                column = new ShortIndex(name, table);
                break;
            }
            case INT: {
                column = new IntegerIndex(name, table);
                break;
            }
            case LONG: {
                column = new LongIndex(name, table);
                break;
            }
            case FLOAT: {
                column = new FloatIndex(name, table);
                break;
            }
            case DOUBLE: {
                column = new DoubleIndex(name, table);
                break;
            }
            case TEXT: {
                column = new TextIndex(name, table, table.getCollectionTextSearchIndex());
                break;
            }
            case REFERENCE: {
                column = new SingleReferenceIndex(name, table);
                break;
            }
            case MULTI_REFERENCE: {
                column = new MultiReferenceIndex(name, table, table.getReferenceBlockChain());
                break;
            }
            case FILE: {
                column = new FileIndex(name, table, FullTextIndexingOptions.INDEXED, table.getCollectionTextSearchIndex(), table.getFileStore());
            }
        }
        return column;
    }

    default public String getStringValue(int id) {
        TYPE value = this.getGenericValue(id);
        if (value == null) {
            return "NULL";
        }
        switch (this.getType()) {
            case MULTI_REFERENCE: {
                ReferenceIteratorValue referenceIteratorValue = (ReferenceIteratorValue)value;
                PrimitiveIterator.OfInt idIterator = referenceIteratorValue.getIdIterator();
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                int counter = 0;
                while (idIterator.hasNext()) {
                    if (counter > 0) {
                        sb.append(", ");
                    }
                    if (counter > 100) {
                        sb.append("...");
                        break;
                    }
                    sb.append(idIterator.nextInt());
                    ++counter;
                }
                sb.append(")");
                return sb.toString();
            }
            case FILE: {
                FileValue fileValue = (FileValue)value;
                if (fileValue.getMetaData() != null) {
                    return fileValue.getMetaData().getName() + " (" + fileValue.getMetaData().getSize() + ")";
                }
                return fileValue.getUuid();
            }
        }
        return value.toString();
    }

    public String getName();

    public TableIndex getTable();

    @Override
    public String getFQN();

    public IndexType getType();

    public FullTextIndexingOptions getFullTextIndexingOptions();

    @Override
    public int getMappingId();

    @Override
    public void setMappingId(int var1);

    public TYPE getGenericValue(int var1);

    public void setGenericValue(int var1, TYPE var2);

    public void removeValue(int var1);

    public void writeTransactionValue(TYPE var1, DataOutputStream var2) throws IOException;

    public TYPE readTransactionValue(DataInputStream var1) throws IOException;

    default public ColumnIndex getReferencedColumn() {
        return null;
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter) {
        return new IndexFilter(this, filter);
    }

    default public IndexFilter<TYPE, FILTER> createFilter(FILTER filter, IndexPath indexPath) {
        return new IndexFilter(this, filter, indexPath);
    }

    default public void writeSchema(DataOutputStream dataOutputStream) throws IOException {
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.getName());
        dataOutputStream.writeInt(this.getType().getId());
        dataOutputStream.writeInt(this.getMappingId());
    }

    public List<SortEntry> sortRecords(List<SortEntry> var1, boolean var2);

    public BitSet filter(BitSet var1, FILTER var2);

    public void close();

    public void drop();
}

