/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.HashMap;
import java.util.Map;

public enum IndexType {
    BOOLEAN(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    TEXT(7),
    REFERENCE(8),
    MULTI_REFERENCE(9),
    FILE(10),
    BINARY(11);

    private final int id;
    private static final Map<Integer, IndexType> indexTypeById;

    private IndexType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static IndexType getIndexTypeById(int id) {
        return indexTypeById.get(id);
    }

    static {
        indexTypeById = new HashMap<Integer, IndexType>();
        for (IndexType indexType : IndexType.values()) {
            indexTypeById.put(indexType.getId(), indexType);
        }
    }
}

