/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import org.teamapps.universaldb.index.text.TextFilterType;

public class TextFilter {
    private final TextFilterType filterType;
    private final String value;

    public static TextFilter emptyFilter() {
        return new TextFilter(TextFilterType.EMPTY, null);
    }

    public static TextFilter notEmptyFilter() {
        return new TextFilter(TextFilterType.NOT_EMPTY, null);
    }

    public static TextFilter textEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TEXT_EQUALS, value);
    }

    public static TextFilter textNotEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TEXT_NOT_EQUALS, value);
    }

    public static TextFilter textByteLengthGreaterFilter(int size) {
        return new TextFilter(TextFilterType.TEXT_BYTE_LENGTH_GREATER, "" + size);
    }

    public static TextFilter textByteLengthSmallerFilter(int size) {
        return new TextFilter(TextFilterType.TEXT_BYTE_LENGTH_SMALLER, "" + size);
    }

    public static TextFilter termEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_EQUALS, value);
    }

    public static TextFilter termNotEqualsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_NOT_EQUALS, value);
    }

    public static TextFilter termStartsWithFilter(String value) {
        return new TextFilter(TextFilterType.TERM_STARTS_WITH, value);
    }

    public static TextFilter termStartsNotWithFilter(String value) {
        return new TextFilter(TextFilterType.TERM_STARTS_NOT_WITH, value);
    }

    public static TextFilter termSimilarFilter(String value) {
        return new TextFilter(TextFilterType.TERM_SIMILAR, value);
    }

    public static TextFilter termNotSimilarFilter(String value) {
        return new TextFilter(TextFilterType.TERM_NOT_SIMILAR, value);
    }

    public static TextFilter termContainsFilter(String value) {
        return new TextFilter(TextFilterType.TERM_CONTAINS, value);
    }

    public static TextFilter termContainsNotFilter(String value) {
        return new TextFilter(TextFilterType.TERM_CONTAINS_NOT, value);
    }

    protected TextFilter(TextFilterType filterType, String value) {
        this.filterType = filterType;
        this.value = value;
    }

    protected TextFilterType getFilterType() {
        return this.filterType;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.filterType + ":" + this.value;
    }
}

