/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo.template;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.template.TemplateUtil;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Table;

public class PojoTemplate {
    private String template;
    private List<String> methods = new ArrayList<String>();
    private Map<String, String> blocks = TemplateUtil.getTemplateBlocksMap();

    public static PojoTemplate createSchemaInterface() throws IOException {
        return PojoTemplate.create("SchemaInterface.txt");
    }

    public static PojoTemplate createEntityInterface() throws IOException {
        return PojoTemplate.create("EntityInterface.txt");
    }

    public static PojoTemplate createUdbEntity() throws IOException {
        return PojoTemplate.create("UdbEntity.txt");
    }

    public static PojoTemplate createQueryInterface() throws IOException {
        return PojoTemplate.create("QueryInterface.txt");
    }

    public static PojoTemplate createUdbQuery() throws IOException {
        return PojoTemplate.create("UdbQuery.txt");
    }

    public static PojoTemplate createEnum() throws IOException {
        return PojoTemplate.create("Enum.txt");
    }

    public static PojoTemplate create(String name) throws IOException {
        String tpl = TemplateUtil.readeTemplate(name);
        return new PojoTemplate(tpl);
    }

    public PojoTemplate(String template) {
        this.template = template;
    }

    public void setValue(String name, String value) {
        this.template = TemplateUtil.setValue(this.template, name, value);
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean addInterfaceGetMethod(Column column, int version) {
        String tpl;
        ColumnType type = column.getType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("INTERFACE_GET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(column.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            tpl = TemplateUtil.setValue(tpl, "reference", this.firstUpper(column.getReferencedTable().getName()));
        } else if (type == ColumnType.ENUM) {
            String enumType = this.firstUpper(column.getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addInterfaceSetMethod(Column column, Table table, int version) {
        String tpl;
        ColumnType type = column.getType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("INTERFACE_SET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(column.getName()));
        tpl = TemplateUtil.setValue(tpl, "type", this.firstUpper(table.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            tpl = TemplateUtil.setValue(tpl, "reference", this.firstUpper(column.getReferencedTable().getName()));
        } else if (type == ColumnType.ENUM) {
            String enumType = this.firstUpper(column.getName());
            tpl = TemplateUtil.setValue(tpl, "enum", enumType);
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addUdbEntityGetMethod(Column column, int version) {
        String tpl;
        ColumnType type = column.getType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("ENTITY_GET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(column.getName()));
        tpl = TemplateUtil.setValue(tpl, "name2", column.getName());
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            tpl = TemplateUtil.setValue(tpl, "otherType", this.firstUpper(column.getReferencedTable().getName()));
            tpl = TemplateUtil.setValue(tpl, "name2", column.getName());
        } else if (type == ColumnType.ENUM) {
            // empty if block
        }
        this.methods.add(tpl);
        return true;
    }

    public boolean addUdbEntitySetMethod(Column column, Table table, int version) {
        String tpl;
        ColumnType type = column.getType();
        Object versionTag = "";
        if (version > 1) {
            versionTag = "_" + version;
        }
        if ((tpl = this.blocks.get("ENTITY_SET_METHOD_" + type.name() + (String)versionTag)) == null) {
            return false;
        }
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(column.getName()));
        tpl = TemplateUtil.setValue(tpl, "name2", column.getName());
        tpl = TemplateUtil.setValue(tpl, "type", this.firstUpper(table.getName()));
        if (type == ColumnType.SINGLE_REFERENCE || type == ColumnType.MULTI_REFERENCE) {
            tpl = TemplateUtil.setValue(tpl, "otherType", this.firstUpper(column.getReferencedTable().getName()));
            tpl = TemplateUtil.setValue(tpl, "name2", column.getName());
        } else if (type == ColumnType.ENUM) {
            // empty if block
        }
        this.methods.add(tpl);
        return true;
    }

    public void addQueryInterfaceMethod(Column column, String query) {
        if (column.getType() == ColumnType.ENUM) {
            String enumType = this.firstUpper(column.getName());
            String method = "\t" + query + " " + column.getName() + "(EnumFilterType filterType, " + this.firstUpper(column.getName()) + " ... enums);";
            this.methods.add(method);
        } else {
            String method = "\t" + query + " " + column.getName() + "(" + this.getFilterTypeName(column.getType()) + " filter);";
            this.methods.add(method);
        }
    }

    public void addSubQueryInterfaceMethod(Column column, String query) {
        Table referencedTable = column.getReferencedTable();
        if (column.getType().isReference()) {
            String method = "\t" + query + " filter" + this.firstUpper(column.getName()) + "(" + this.firstUpper(column.getReferencedTable().getName() + "Query") + " query);";
            this.methods.add(method);
        }
        if (column.getType() == ColumnType.MULTI_REFERENCE) {
            this.methods.add("\t" + query + " " + column.getName() + "(MultiReferenceFilterType type, " + this.firstUpper(referencedTable.getName()) + " ... value);");
            this.methods.add("\t" + query + " " + column.getName() + "Count(MultiReferenceFilterType type, int count);");
        }
    }

    public void addUdbSubQueryMethod(Column column, String query, String type) {
        if (!column.getType().isReference()) {
            return;
        }
        String tpl = this.blocks.get("QUERY_SUB_QUERY");
        Table referencedTable = column.getReferencedTable();
        String backReference = column.getBackReference();
        if (backReference == null) {
            tpl = this.blocks.get("QUERY_SUB_QUERY_2");
        }
        String name = this.firstUpper(column.getName());
        String name2 = column.getName();
        String udbType = "Udb" + type;
        String otherType = this.firstUpper(referencedTable.getName());
        tpl = TemplateUtil.setValue(tpl, "name", name);
        tpl = TemplateUtil.setValue(tpl, "query", query);
        tpl = TemplateUtil.setValue(tpl, "otherQuery", this.firstUpper(referencedTable.getName()) + "Query");
        tpl = TemplateUtil.setValue(tpl, "udbOtherQuery", "Udb" + otherType + "Query");
        tpl = TemplateUtil.setValue(tpl, "otherUdbType", "Udb" + this.firstUpper(referencedTable.getName()));
        if (backReference != null) {
            tpl = TemplateUtil.setValue(tpl, "otherName2", backReference);
        }
        tpl = TemplateUtil.setValue(tpl, "name2", name2);
        tpl = TemplateUtil.setValue(tpl, "type", type);
        tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
        this.methods.add(tpl);
        if (column.getType() == ColumnType.MULTI_REFERENCE) {
            tpl = this.blocks.get("QUERY_MULTI_REFERENCE");
            tpl = TemplateUtil.setValue(tpl, "otherType", otherType);
            tpl = TemplateUtil.setValue(tpl, "name", name);
            tpl = TemplateUtil.setValue(tpl, "name2", name2);
            tpl = TemplateUtil.setValue(tpl, "query", query);
            tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
            this.methods.add(tpl);
            tpl = this.blocks.get("QUERY_MULTI_REFERENCE_2");
            tpl = TemplateUtil.setValue(tpl, "type", type);
            tpl = TemplateUtil.setValue(tpl, "name", name);
            tpl = TemplateUtil.setValue(tpl, "name2", name2);
            tpl = TemplateUtil.setValue(tpl, "query", query);
            tpl = TemplateUtil.setValue(tpl, "udbType", udbType);
            this.methods.add(tpl);
        }
    }

    public void addUdbQueryMethod(Column column, String query, String type) {
        String name = column.getName();
        String tpl = this.blocks.get("QUERY_METHOD");
        if (column.getType() == ColumnType.ENUM) {
            tpl = this.blocks.get("QUERY_ENUMS");
            tpl = TemplateUtil.setValue(tpl, "enumType", this.firstUpper(column.getName()));
        }
        tpl = TemplateUtil.setValue(tpl, "query", query);
        tpl = TemplateUtil.setValue(tpl, "name", this.firstUpper(name));
        tpl = TemplateUtil.setValue(tpl, "name2", name);
        tpl = TemplateUtil.setValue(tpl, "udbType", "Udb" + type);
        tpl = TemplateUtil.setValue(tpl, "filter", this.getFilterTypeName(column.getType()));
        this.methods.add(tpl);
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public String tabs(int count) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t".repeat(count));
        return sb.toString();
    }

    public String nl() {
        return "\n";
    }

    public String firstUpper(String s) {
        return TemplateUtil.firstUpperCase(s);
    }

    public String createConstantName(String s) {
        return s.replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase();
    }

    public String getIndexTypeName(ColumnType type) {
        IndexType indexType = type.getIndexType();
        switch (indexType) {
            case BOOLEAN: {
                return BooleanIndex.class.getSimpleName();
            }
            case SHORT: {
                return ShortIndex.class.getSimpleName();
            }
            case INT: {
                return IntegerIndex.class.getSimpleName();
            }
            case LONG: {
                return LongIndex.class.getSimpleName();
            }
            case FLOAT: {
                return FloatIndex.class.getSimpleName();
            }
            case DOUBLE: {
                return DoubleIndex.class.getSimpleName();
            }
            case TEXT: {
                return TextIndex.class.getSimpleName();
            }
            case REFERENCE: {
                return SingleReferenceIndex.class.getSimpleName();
            }
            case MULTI_REFERENCE: {
                return MultiReferenceIndex.class.getSimpleName();
            }
            case FILE: {
                return FileIndex.class.getSimpleName();
            }
        }
        return null;
    }

    public String getFilterTypeName(ColumnType type) {
        switch (type) {
            case BOOLEAN: {
                return BooleanFilter.class.getSimpleName();
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return NumericFilter.class.getSimpleName();
            }
            case TEXT: {
                return TextFilter.class.getSimpleName();
            }
            case FILE: {
                return FileFilter.class.getSimpleName();
            }
            case SINGLE_REFERENCE: {
                return NumericFilter.class.getSimpleName();
            }
            case MULTI_REFERENCE: {
                return MultiReferenceFilter.class.getSimpleName();
            }
            case TIMESTAMP: {
                return NumericFilter.class.getSimpleName();
            }
            case DATE: {
                return NumericFilter.class.getSimpleName();
            }
            case TIME: {
                return NumericFilter.class.getSimpleName();
            }
            case DATE_TIME: {
                return NumericFilter.class.getSimpleName();
            }
            case LOCAL_DATE: {
                return NumericFilter.class.getSimpleName();
            }
            case ENUM: {
                return NumericFilter.class.getSimpleName();
            }
            case CURRENCY: {
                break;
            }
        }
        return null;
    }

    public void writeTemplate(String name, File dir) throws IOException {
        if (!this.methods.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String method : this.methods) {
                sb.append(method).append("\n\n");
            }
            this.setValue("methods", sb.toString());
            this.methods.clear();
        }
        File file = new File(dir, TemplateUtil.firstUpperCase(name) + ".java");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        writer.write(this.template);
        writer.close();
    }
}

