/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileIndex;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.query.IndexFilter;
import org.teamapps.universaldb.query.IndexPath;

public class OrFilter
implements Filter {
    private List<Filter> filters = new ArrayList<Filter>();

    public OrFilter() {
    }

    public OrFilter(Filter filter) {
        this.filters.add(filter);
    }

    public OrFilter(Filter filterA, Filter filterB) {
        this.filters.add(filterA);
        this.filters.add(filterB);
    }

    @Override
    public Filter or(Filter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    @Override
    public void prependPath(IndexPath path) {
        this.filters.forEach(filter -> filter.prependPath(path));
    }

    @Override
    public BitSet filter(BitSet input) {
        List<List<Filter>> mappedFilters = Filter.mapFiltersByPathAndExpense(this.filters);
        BitSet result = null;
        for (List<Filter> filters : mappedFilters) {
            BitSet reduced;
            IndexPath path = filters.get(0).getPath();
            if (path == null) {
                for (Filter filter : filters) {
                    BitSet reduced2 = filter.filter(input);
                    if (result == null) {
                        result = reduced2;
                        continue;
                    }
                    result.or(reduced2);
                }
                continue;
            }
            BitSet localRecords = path.calculatePathBitSet(input);
            BitSet localResult = null;
            List<IndexFilter> collectionFullTextFilters = Filter.getCollectionFullTextFilters(filters);
            if (!collectionFullTextFilters.isEmpty()) {
                List<TextFieldFilter> textFilters = IndexFilter.createTextFilters(collectionFullTextFilters);
                TableIndex table = collectionFullTextFilters.get(0).getColumnIndex().getTable();
                reduced = table.getCollectionTextSearchIndex().filter(localRecords, textFilters, false);
                BitSet fullTextResult = null;
                for (IndexFilter filter : Filter.getCollectionFullTextFiltersWithLocalIndexFilterPart(filters)) {
                    ColumnIndex columnIndex = filter.getColumnIndex();
                    if (columnIndex instanceof TextIndex) {
                        TextIndex textIndex = (TextIndex)columnIndex;
                        BitSet fullTextReduced = textIndex.filter(reduced, (TextFilter)filter.getFilter(), false);
                        if (fullTextResult == null) {
                            fullTextResult = fullTextReduced;
                            continue;
                        }
                        fullTextResult.or(fullTextReduced);
                        continue;
                    }
                    if (!(columnIndex instanceof FileIndex)) continue;
                    FileIndex fileIndex = (FileIndex)columnIndex;
                }
                localResult = fullTextResult;
            }
            for (Filter filter : Filter.getNonCollectionFullTextFilters(filters)) {
                reduced = filter.localFilter(localRecords);
                if (localResult == null) {
                    localResult = reduced;
                    continue;
                }
                localResult.or(reduced);
            }
            BitSet pathResult = path.calculateReversePath(localResult, input);
            if (result == null) {
                result = pathResult;
                continue;
            }
            result.or(pathResult);
        }
        return result;
    }

    @Override
    public BitSet localFilter(BitSet localRecords) {
        BitSet result = null;
        for (Filter filter : this.filters) {
            BitSet reduced = filter.filter(localRecords);
            if (result == null) {
                result = reduced;
                continue;
            }
            result.or(reduced);
        }
        return result;
    }

    @Override
    public IndexPath getPath() {
        IndexPath lastPath = null;
        for (Filter filter : this.filters) {
            if (lastPath == null) {
                lastPath = filter.getPath();
                continue;
            }
            if (lastPath.isSamePath(filter.getPath())) continue;
            return null;
        }
        return lastPath;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public String explain(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExplainTabs(level)).append("OR (").append("\n");
        for (Filter filter : this.filters) {
            sb.append(this.explain(level + 1));
        }
        sb.append(this.getExplainTabs(level)).append(")").append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.explain(0);
    }
}

