/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teamapps.universaldb.index.IndexType;

public enum ColumnType {
    BOOLEAN(1),
    SHORT(2),
    INT(3),
    LONG(4),
    FLOAT(5),
    DOUBLE(6),
    TEXT(7),
    TRANSLATABLE_TEXT(8),
    FILE(9),
    SINGLE_REFERENCE(10),
    MULTI_REFERENCE(11),
    TIMESTAMP(12),
    DATE(13),
    TIME(14),
    DATE_TIME(15),
    LOCAL_DATE(16),
    ENUM(17),
    BINARY(18),
    CURRENCY(19),
    DYNAMIC_CURRENCY(20);

    private final int id;
    private static final Map<Integer, ColumnType> indexTypeById;

    private ColumnType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ColumnType getIndexTypeById(int id) {
        return indexTypeById.get(id);
    }

    public boolean isReference() {
        return this == SINGLE_REFERENCE || this == MULTI_REFERENCE;
    }

    public IndexType getIndexType() {
        switch (this) {
            case BOOLEAN: {
                return IndexType.BOOLEAN;
            }
            case ENUM: 
            case SHORT: {
                return IndexType.SHORT;
            }
            case TIMESTAMP: 
            case TIME: 
            case INT: {
                return IndexType.INT;
            }
            case DATE: 
            case DATE_TIME: 
            case LOCAL_DATE: 
            case LONG: {
                return IndexType.LONG;
            }
            case FLOAT: {
                return IndexType.FLOAT;
            }
            case DOUBLE: {
                return IndexType.DOUBLE;
            }
            case TEXT: {
                return IndexType.TEXT;
            }
            case TRANSLATABLE_TEXT: {
                return IndexType.TRANSLATABLE_TEXT;
            }
            case FILE: {
                return IndexType.FILE;
            }
            case BINARY: {
                return IndexType.BINARY;
            }
            case SINGLE_REFERENCE: {
                return IndexType.REFERENCE;
            }
            case MULTI_REFERENCE: {
                return IndexType.MULTI_REFERENCE;
            }
        }
        return null;
    }

    public static Set<String> getNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (ColumnType value : ColumnType.values()) {
            nameSet.add(value.name());
        }
        return nameSet;
    }

    static {
        indexTypeById = new HashMap<Integer, ColumnType>();
        for (ColumnType type : ColumnType.values()) {
            indexTypeById.put(type.getId(), type);
        }
    }
}

