/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.bool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.transaction.DataType;

public class BooleanIndex
extends AbstractBufferIndex<Boolean, BooleanFilter> {
    public static final int ENTRY_SIZE = 1;
    public static final byte[] BIT_MASKS = new byte[8];

    public BooleanIndex(String name, TableIndex tableIndex) {
        super(name, tableIndex, FullTextIndexingOptions.NOT_INDEXED);
    }

    @Override
    protected int getEntrySize() {
        return 1;
    }

    @Override
    public IndexType getType() {
        return IndexType.BOOLEAN;
    }

    @Override
    public Boolean getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Boolean value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, false);
    }

    @Override
    public BitSet filter(BitSet records, BooleanFilter booleanFilter) {
        if (booleanFilter.getFilterValue()) {
            return this.filterEquals(records, true);
        }
        return this.filterEquals(records, false);
    }

    public boolean getValue(int id) {
        if (id > this.getMaximumId() * 8) {
            return false;
        }
        int index = this.getIndexForId(id / 8);
        int offset = this.getOffsetForIndex(index);
        int position = id / 8 - offset;
        int bit = id % 8;
        byte b = this.getBuffer(index).getByte(position);
        boolean value = false;
        if ((b & BIT_MASKS[bit]) == BIT_MASKS[bit]) {
            value = true;
        }
        return value;
    }

    public void setValue(int id, boolean value) {
        this.ensureBufferSize(id / 8 + 1);
        int index = this.getIndexForId(id / 8);
        int offset = this.getOffsetForIndex(index);
        int position = id / 8 - offset;
        int bit = id % 8;
        byte b = this.getBuffer(index).getByte(position);
        b = value ? (byte)(b | BIT_MASKS[bit]) : (byte)(b & ~BIT_MASKS[bit]);
        this.getBuffer(index).putByte(position, b);
    }

    @Override
    public void writeTransactionValue(Boolean value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.BOOLEAN.getId());
        dataOutputStream.writeBoolean(value);
    }

    @Override
    public Boolean readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readBoolean();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            boolean value1 = this.getValue(o1.getLeafId());
            boolean value2 = this.getValue(o2.getLeafId());
            return Boolean.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    public BitSet filterEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, boolean compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            boolean value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    static {
        BooleanIndex.BIT_MASKS[0] = 1;
        BooleanIndex.BIT_MASKS[1] = 2;
        BooleanIndex.BIT_MASKS[2] = 4;
        BooleanIndex.BIT_MASKS[3] = 8;
        BooleanIndex.BIT_MASKS[4] = 16;
        BooleanIndex.BIT_MASKS[5] = 32;
        BooleanIndex.BIT_MASKS[6] = 64;
        BooleanIndex.BIT_MASKS[7] = -128;
    }
}

