/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex;

import java.util.HashMap;
import java.util.Map;

public enum BlockType {
    SINGLE_ENTRY(1, 1, 0),
    ENTRIES_2(2, 2, 0),
    ENTRIES_4(3, 4, 1),
    ENTRIES_8(4, 8, 1),
    ENTRIES_16(5, 16, 1),
    ENTRIES_32(6, 32, 1),
    ENTRIES_64(7, 64, 1),
    ENTRIES_128(8, 128, 2),
    ENTRIES_256(9, 256, 2),
    ENTRIES_512(10, 512, 2),
    ENTRIES_1024(11, 1024, 2),
    ENTRIES_2048(12, 2048, 2),
    ENTRIES_4096_START(13, 4096, 2, 20),
    ENTRIES_4099_CONTINUE(14, 4099, 2, 8);

    private static Map<Integer, BlockType> blockTypeByEntrySize;
    private int id;
    private int maxEntries;
    private int entryCountSize;
    private int blockSize;
    private int dataOffset;
    private boolean canContainEmptyEntries;
    private boolean singleBlock;

    private static BlockType calculateEntryType(int entries) {
        BlockType result = null;
        for (BlockType type : BlockType.values()) {
            if (type.getMaxEntries() < entries) continue;
            result = type;
            break;
        }
        if (result != null && result != ENTRIES_4099_CONTINUE) {
            return result;
        }
        return ENTRIES_4096_START;
    }

    public static BlockType getEntryType(int entries) {
        if (entries > ENTRIES_2048.getMaxEntries()) {
            return ENTRIES_4096_START;
        }
        return blockTypeByEntrySize.get(entries);
    }

    private BlockType(int id, int maxEntries, int entryCountSize) {
        this(id, maxEntries, entryCountSize, 0);
    }

    private BlockType(int id, int maxEntries, int entryCountSize, int headerDataSize) {
        this.id = id;
        this.maxEntries = maxEntries;
        this.entryCountSize = entryCountSize;
        this.blockSize = 1 + maxEntries * 4 + entryCountSize + headerDataSize;
        this.dataOffset = 1 + entryCountSize + headerDataSize;
        if (entryCountSize > 0) {
            this.canContainEmptyEntries = true;
        }
        this.singleBlock = id < 13;
    }

    public static BlockType getById(int id) {
        return BlockType.values()[id - 1];
    }

    public int getId() {
        return this.id;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getEntryCountSize() {
        return this.entryCountSize;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public boolean canContainEmptyEntries() {
        return this.canContainEmptyEntries;
    }

    public boolean isSingleBlock() {
        return this.singleBlock;
    }

    public BlockType getNextSize() {
        if (this.id < 14) {
            return BlockType.getById(this.id + 1);
        }
        return BlockType.getById(14);
    }

    public BlockType getNextSize(int newEntries) {
        int entries = this.maxEntries + newEntries;
        return BlockType.getEntryType(entries);
    }

    static {
        blockTypeByEntrySize = new HashMap<Integer, BlockType>();
        for (int i = 1; i <= ENTRIES_2048.getMaxEntries(); ++i) {
            blockTypeByEntrySize.put(i, BlockType.calculateEntryType(i));
        }
    }
}

