/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex.iterator;

import java.util.PrimitiveIterator;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlock;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockProvider;

public class ChainedBlockIterator
implements PrimitiveIterator.OfInt {
    private final ReferenceBlockProvider blockProvider;
    private ReferenceBlock block;
    private ReferenceBlock nextBlock;
    private int nextValue;
    private int dataOffset;
    private int blockEntryPosition;
    private int blockEntries;

    public ChainedBlockIterator(ReferenceBlock block, ReferenceBlockProvider blockProvider) {
        this.blockProvider = blockProvider;
        this.block = block;
        this.setBlockData(block);
        this.retrieveNextValue();
    }

    private void setBlockData(ReferenceBlock block) {
        this.dataOffset = block.getBlockDataPosition();
        this.blockEntryPosition = 0;
        this.blockEntries = block.getBlockEntryCount();
        this.nextBlock = this.blockProvider.getBlock(block.getNextIndex());
    }

    private void retrieveNextValue() {
        if (this.nextBlock == null && this.blockEntryPosition >= this.blockEntries) {
            this.nextValue = 0;
            return;
        }
        this.nextValue = this.block.getBuffer().readInt(this.dataOffset + this.blockEntryPosition * 4);
        ++this.blockEntryPosition;
        if (this.blockEntryPosition == this.blockEntries && this.nextBlock != null) {
            this.block = this.nextBlock;
            this.setBlockData(this.nextBlock);
        }
        if (this.nextValue < 0) {
            this.retrieveNextValue();
        }
    }

    @Override
    public int nextInt() {
        int value = this.nextValue;
        this.retrieveNextValue();
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.nextValue > 0;
    }
}

