/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class EntityChangeSet {
    private final Map<Integer, TransactionRecordValue> changeMap = new HashMap<Integer, TransactionRecordValue>();
    private final Map<Integer, AbstractUdbEntity> changedReferenceMap = new HashMap<Integer, AbstractUdbEntity>();
    private final Map<RecordReference, Entity> entityByReference = new HashMap<RecordReference, Entity>();

    public void addChangeValue(ColumnIndex column, Object value) {
        TransactionRecordValue recordValue = new TransactionRecordValue(column, value);
        this.changeMap.put(recordValue.getColumnMappingId(), recordValue);
    }

    public void addRecordReference(RecordReference reference, Entity entity) {
        this.entityByReference.put(reference, entity);
    }

    public Map<RecordReference, Entity> getEntityByReference() {
        return this.entityByReference;
    }

    public TransactionRecordValue getChangeValue(ColumnIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public boolean isChanged(ColumnIndex columnIndex) {
        return this.changeMap.containsKey(columnIndex.getMappingId());
    }

    public void setTransactionRecordValues(TransactionRecord transactionRecord) {
        this.changeMap.values().forEach(transactionRecord::addRecordValue);
    }

    public void setReferenceChange(ColumnIndex index, AbstractUdbEntity reference) {
        this.changedReferenceMap.put(index.getMappingId(), reference);
    }

    public AbstractUdbEntity getReferenceChange(ColumnIndex index) {
        return this.changedReferenceMap.get(index.getMappingId());
    }
}

