/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRequest;

public class ClusterTransaction {
    private static final Logger log = LoggerFactory.getLogger(ClusterTransaction.class);
    private static final AtomicLong transactionRequestIdGenerator = new AtomicLong();
    private final long transactionRequestId;
    private final long timestamp;
    private final int userId;
    private long transactionId;
    private List<TransactionRecord> transactionRecords;
    private Map<Integer, Integer> recordIdByCorrelationId;

    public ClusterTransaction(int userId) {
        this(transactionRequestIdGenerator.incrementAndGet(), userId);
    }

    public ClusterTransaction(long transactionRequestId, int userId) {
        this.transactionRequestId = transactionRequestId;
        this.timestamp = System.currentTimeMillis();
        this.userId = userId;
        this.transactionRecords = new ArrayList<TransactionRecord>();
        this.recordIdByCorrelationId = new HashMap<Integer, Integer>();
    }

    public ClusterTransaction(TransactionPacket packet, DataBaseMapper dataBaseMapper) throws IOException {
        this.transactionRequestId = packet.getTransactionRequestId();
        this.transactionId = packet.getTransactionId();
        this.timestamp = packet.getTimestamp();
        this.userId = packet.getUserId();
        this.transactionRecords = new ArrayList<TransactionRecord>();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet.getTransactionData()));
        int records = dataInputStream.readInt();
        for (int i = 0; i < records; ++i) {
            this.transactionRecords.add(new TransactionRecord(dataInputStream, dataBaseMapper));
        }
        this.recordIdByCorrelationId = new HashMap<Integer, Integer>();
        if (packet.getCorrelationData() != null) {
            dataInputStream = new DataInputStream(new ByteArrayInputStream(packet.getCorrelationData()));
            int mapSize = dataInputStream.readInt();
            for (int i = 0; i < mapSize; ++i) {
                int key = dataInputStream.readInt();
                int value = dataInputStream.readInt();
                this.recordIdByCorrelationId.put(key, value);
            }
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getUserId() {
        return this.userId;
    }

    public TransactionRequest createRequest() {
        return new TransactionRequest(this);
    }

    public TransactionRecord addTransactionRecord(TableIndex tableIndex, int recordId, int correlationId, boolean strictChangeVerification) {
        TransactionRecord transactionRecord = new TransactionRecord(tableIndex, recordId, correlationId, this.userId, recordId > 0, false, strictChangeVerification);
        return this.addTransactionRecord(transactionRecord);
    }

    public TransactionRecord addTransactionRecord(TransactionRecord transactionRecord) {
        this.transactionRecords.add(transactionRecord);
        return transactionRecord;
    }

    public long getTransactionRequestId() {
        return this.transactionRequestId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public List<TransactionRecord> getTransactionRecords() {
        return this.transactionRecords;
    }

    public void setTransactionRecords(List<TransactionRecord> transactionRecords) {
        this.transactionRecords = transactionRecords;
    }

    public void writeTransactionData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.transactionRecords.size());
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            transactionRecord.writeTransactionValue(dataOutputStream);
        }
    }

    public void writeTransactionCorrelationData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.recordIdByCorrelationId.size());
        for (Map.Entry<Integer, Integer> entry : this.recordIdByCorrelationId.entrySet()) {
            dataOutputStream.writeInt(entry.getKey());
            dataOutputStream.writeInt(entry.getValue());
        }
    }

    public TransactionPacket createTransactionPacket() throws IOException {
        TransactionPacket transactionPacket = new TransactionPacket(this.transactionRequestId, this.transactionId, this.timestamp, this.userId);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeTransactionData(new DataOutputStream(byteArrayOutputStream));
        transactionPacket.setTransactionData(byteArrayOutputStream.toByteArray());
        if (this.recordIdByCorrelationId.size() > 0) {
            byte[] correlationData = this.getCorrelationData();
            transactionPacket.setCorrelationData(correlationData);
        }
        return transactionPacket;
    }

    private byte[] getCorrelationData() throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        this.writeTransactionCorrelationData(new DataOutputStream(byteArrayStream));
        return byteArrayStream.toByteArray();
    }

    public TransactionPacket resolveAndExecuteTransaction(TransactionIdProvider transactionIdProvider, TransactionPacket packet) throws IOException {
        this.transactionId = transactionIdProvider.getNextTransactionId();
        boolean dataChangeCheckSuccess = true;
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            if (transactionRecord.checkUnchangedRecordTransactionId()) continue;
            dataChangeCheckSuccess = false;
            break;
        }
        if (!dataChangeCheckSuccess) {
            log.warn("Transaction failed with strict data change check!");
            return null;
        }
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            transactionRecord.createIfNotExists(this.recordIdByCorrelationId);
        }
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            transactionRecord.persistChanges(this.transactionId, this.recordIdByCorrelationId);
        }
        if (packet == null) {
            return this.createTransactionPacket();
        }
        packet.setTransactionId(this.transactionId);
        if (this.recordIdByCorrelationId.size() > 0) {
            packet.setCorrelationData(this.getCorrelationData());
        }
        return packet;
    }

    public void executeResolvedTransaction() {
        for (TransactionRecord transactionRecord : this.transactionRecords) {
            transactionRecord.persistResolvedChanges(this.transactionId, this.recordIdByCorrelationId);
        }
    }

    public int getResolvedRecordIdByCorrelationId(int correlationId) {
        if (this.recordIdByCorrelationId.containsKey(correlationId)) {
            return this.recordIdByCorrelationId.get(correlationId);
        }
        return 0;
    }
}

