/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.IOException;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionRecord;

public class Transaction {
    private static UniversalDB dataBase;
    private final ClusterTransaction clusterTransaction;

    public static void setDataBase(UniversalDB db) {
        dataBase = db;
    }

    public static Transaction create() {
        return new Transaction(UniversalDB.getUserId());
    }

    private Transaction(int userId) {
        this.clusterTransaction = new ClusterTransaction(userId);
    }

    public int getUserId() {
        return this.clusterTransaction.getUserId();
    }

    public void addTransactionRecord(TransactionRecord transactionRecord) {
        this.clusterTransaction.addTransactionRecord(transactionRecord);
    }

    public void execute() {
        try {
            dataBase.executeTransaction(this.clusterTransaction);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getResolvedRecordIdByCorrelationId(int correlationId) {
        return this.clusterTransaction.getResolvedRecordIdByCorrelationId(correlationId);
    }
}

