/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.teamapps.universaldb.cluster.Cluster;
import org.teamapps.universaldb.cluster.ClusterConfig;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.file.LocalFileStore;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionHandler;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;
import org.teamapps.universaldb.transaction.TransactionRequest;
import org.teamapps.universaldb.transaction.TransactionStore;

public class UniversalDB
implements DataBaseMapper,
TransactionHandler {
    private static final ThreadLocal<Integer> THREAD_LOCAL_USER_ID = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Transaction> THREAD_LOCAL_TRANSACTION = new ThreadLocal();
    private final File storagePath;
    private final TransactionStore transactionStore;
    private final Map<Integer, DatabaseIndex> databaseById = new HashMap<Integer, DatabaseIndex>();
    private final Map<Integer, TableIndex> tableById = new HashMap<Integer, TableIndex>();
    private final Map<Integer, ColumnIndex> columnById = new HashMap<Integer, ColumnIndex>();
    private final SchemaIndex schemaIndex;
    private Cluster cluster;

    public static int getUserId() {
        return THREAD_LOCAL_USER_ID.get();
    }

    public static void setUserId(int userId) {
        THREAD_LOCAL_USER_ID.set(userId);
    }

    public static void startThreadLocalTransaction() {
        THREAD_LOCAL_TRANSACTION.set(Transaction.create());
    }

    public static Transaction getThreadLocalTransaction() {
        return THREAD_LOCAL_TRANSACTION.get();
    }

    public static void executeThreadLocalTransaction() {
        Transaction transaction = THREAD_LOCAL_TRANSACTION.get();
        transaction.execute();
        THREAD_LOCAL_TRANSACTION.set(null);
    }

    public static UniversalDB createStandalone(File storagePath, SchemaInfoProvider schemaInfoProvider) throws Exception {
        LocalFileStore fileStore = new LocalFileStore(new File(storagePath, "file-store"));
        return new UniversalDB(storagePath, schemaInfoProvider, fileStore, null);
    }

    public static UniversalDB createStandalone(File storagePath, Schema schema) throws IOException {
        return new UniversalDB(storagePath, schema, null);
    }

    public static UniversalDB createClusterNode(File storagePath, Schema schema, ClusterConfig clusterConfig) throws IOException {
        return new UniversalDB(storagePath, schema, clusterConfig);
    }

    public static UniversalDB createClusterNode(File storagePath, ClusterConfig clusterConfig) throws IOException {
        return new UniversalDB(storagePath, new Schema(), clusterConfig);
    }

    public UniversalDB(File storagePath, SchemaInfoProvider schemaInfo, FileStore fileStore, ClusterConfig clusterConfig) throws Exception {
        this.storagePath = storagePath;
        this.transactionStore = new TransactionStore(storagePath);
        Transaction.setDataBase(this);
        Schema schema = Schema.parse(schemaInfo.getSchema());
        String pojoPath = schema.getPojoNamespace();
        this.schemaIndex = new SchemaIndex(Schema.parse(schema.getPojoNamespace()), storagePath);
        this.schemaIndex.setFileStore(fileStore);
        this.mapSchema(schema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            String path = pojoPath + "." + database.getName().toLowerCase();
            for (TableIndex table : database.getTables()) {
                String tableName = table.getName();
                String className = path + ".Udb" + tableName.substring(0, 1).toUpperCase() + tableName.substring(1);
                Class<?> schemaClass = Class.forName(className);
                Method method = schemaClass.getDeclaredMethod("setTableIndex", TableIndex.class);
                method.setAccessible(true);
                method.invoke(null, table);
            }
        }
        if (clusterConfig != null) {
            this.cluster = new Cluster(clusterConfig, this);
        }
    }

    private UniversalDB(File storagePath, Schema schema, ClusterConfig clusterConfig) throws IOException {
        this.storagePath = storagePath;
        this.transactionStore = new TransactionStore(storagePath);
        this.schemaIndex = new SchemaIndex(Schema.parse(schema.getPojoNamespace()), storagePath);
        this.mapSchema(schema);
        if (clusterConfig != null) {
            this.cluster = new Cluster(clusterConfig, this);
        }
    }

    private void mapSchema(Schema schema) throws IOException {
        Schema localSchema = this.transactionStore.getSchema();
        if (localSchema != null) {
            if (!localSchema.isCompatibleWith(schema)) {
                throw new RuntimeException("Cannot load incompatible schema. Current schema is:\n" + schema + "\nNew schema is:\n" + localSchema);
            }
            localSchema.merge(schema);
            this.transactionStore.saveSchema(localSchema);
        } else {
            localSchema = schema;
            this.transactionStore.saveSchema(localSchema);
        }
        localSchema.mapSchema();
        this.schemaIndex.merge(localSchema);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            this.databaseById.put(database.getMappingId(), database);
            for (TableIndex table : database.getTables()) {
                this.tableById.put(table.getMappingId(), table);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    this.columnById.put(columnIndex.getMappingId(), columnIndex);
                }
            }
        }
    }

    public synchronized void executeTransaction(ClusterTransaction transaction) throws IOException {
        TransactionRequest request = transaction.createRequest();
        if (this.cluster != null) {
            this.cluster.executeTransaction(request);
        } else {
            this.transactionStore.executeTransaction(request);
        }
    }

    public void synchronizeTransaction(ClusterTransaction transaction) throws IOException {
        this.transactionStore.synchronizeTransaction(transaction);
    }

    public SchemaIndex getSchemaIndex() {
        return this.schemaIndex;
    }

    @Override
    public DatabaseIndex getDatabaseById(int mappingId) {
        return this.databaseById.get(mappingId);
    }

    @Override
    public TableIndex getCollectionIndexById(int mappingId) {
        return this.tableById.get(mappingId);
    }

    @Override
    public ColumnIndex getColumnById(int mappingId) {
        return this.columnById.get(mappingId);
    }

    @Override
    public long getCurrentTransactionId() {
        return this.transactionStore.getCurrentTransactionId();
    }

    @Override
    public long getLastTransactionId() {
        return this.transactionStore.getLastTransactionId();
    }

    @Override
    public long getTransactionCount() {
        return this.transactionStore.getTransactionCount();
    }

    @Override
    public Schema getSchema() {
        return this.transactionStore.getSchema();
    }

    @Override
    public void updateSchema(Schema schema) throws IOException {
        this.mapSchema(schema);
    }

    @Override
    public Iterator<byte[]> getTransactions(long startTransaction, long lastTransaction) {
        if (startTransaction == 0L) {
            startTransaction = 8L;
        }
        return this.transactionStore.getTransactions(startTransaction, lastTransaction);
    }

    @Override
    public void handleTransactionSynchronizationPacket(TransactionPacket packet) {
        try {
            ClusterTransaction transaction = new ClusterTransaction(packet, this);
            this.synchronizeTransaction(transaction);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataBaseMapper getDatabaseMapper() {
        return this;
    }

    @Override
    public TransactionIdProvider getTransactionIdProvider() {
        return this.transactionStore;
    }

    @Override
    public void executeTransactionRequest(TransactionRequest transactionRequest) throws IOException {
        this.transactionStore.executeTransaction(transactionRequest);
    }
}

