/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.schema;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.MappedObject;
import org.teamapps.universaldb.schema.Table;

public class Column
implements MappedObject {
    private final Table table;
    private final String name;
    private final ColumnType type;
    private final IndexType indexType;
    private int mappingId;
    private Table referencedTable;
    private String backReference;
    private List<String> enumValues;

    public Column(Table table, String name, ColumnType type) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.indexType = type.getIndexType();
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    @Override
    public String getFQN() {
        return this.table.getFQN() + "." + this.name;
    }

    @Override
    public int getMappingId() {
        return this.mappingId;
    }

    @Override
    public void setMappingId(int mappingId) {
        this.mappingId = mappingId;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(Table referencedTable) {
        this.referencedTable = referencedTable;
    }

    public String getBackReference() {
        return this.backReference;
    }

    public void setBackReference(String backReference) {
        this.backReference = backReference;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public String createDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t").append(this.name).append(" as ").append(this.type.name());
        switch (this.type) {
            case SINGLE_REFERENCE: 
            case MULTI_REFERENCE: {
                sb.append(" ");
                sb.append(this.referencedTable.getDatabase().getName()).append(".").append(this.referencedTable.getName());
                sb.append(" BACKREF ");
                if (this.backReference == null) {
                    sb.append("NONE");
                    break;
                }
                sb.append(this.backReference);
                break;
            }
            case ENUM: {
                sb.append(" VALUES (");
                sb.append(this.enumValues.stream().collect(Collectors.joining(", "))).append(")");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return "column: " + this.name + ", type:" + this.getType().name() + ", id:" + this.mappingId;
    }
}

