/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.text;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.text.CharIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextFieldFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.index.text.TextSearchIndex;
import org.teamapps.universaldb.transaction.DataType;

public class TextIndex
extends AbstractIndex<String, TextFilter> {
    private final LongIndex positionIndex;
    private final CharIndex charIndex;
    private final TextSearchIndex searchIndex;
    private final CollectionTextSearchIndex collectionSearchIndex;

    public TextIndex(String name, TableIndex table, CollectionTextSearchIndex collectionSearchIndex) {
        super(name, table, FullTextIndexingOptions.INDEXED);
        this.positionIndex = new LongIndex(name, table);
        this.charIndex = table.getCollectionCharIndex();
        this.searchIndex = null;
        this.collectionSearchIndex = collectionSearchIndex;
    }

    public TextIndex(String name, TableIndex table, boolean withLocalSearchIndex) {
        super(name, table, withLocalSearchIndex ? FullTextIndexingOptions.INDEXED : FullTextIndexingOptions.NOT_INDEXED);
        this.positionIndex = new LongIndex(name, table);
        this.charIndex = table.getCollectionCharIndex();
        this.searchIndex = withLocalSearchIndex ? new TextSearchIndex(this.getPath(), name) : null;
        this.collectionSearchIndex = null;
    }

    public CollectionTextSearchIndex getCollectionSearchIndex() {
        return this.collectionSearchIndex;
    }

    public boolean isFilteredByCollectionTextIndex(TextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().containsFullTextPart();
    }

    public boolean isFilteredExclusivelyByCollectionTextIndex(TextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().isFullTextIndexExclusive();
    }

    @Override
    public IndexType getType() {
        return IndexType.TEXT;
    }

    @Override
    public String getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, String value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    public String getValue(int id) {
        long index = this.positionIndex.getValue(id);
        if (index == 0L) {
            return null;
        }
        return this.charIndex.getText(index);
    }

    public void setValue(int id, String value) {
        long index;
        boolean update = false;
        if (this.searchIndex != null && this.positionIndex.getValue(id) > 0L) {
            update = true;
        }
        if ((index = this.positionIndex.getValue(id)) != 0L) {
            this.charIndex.removeText(index);
        }
        if (value != null && !value.isEmpty()) {
            index = this.charIndex.setText(value);
            this.positionIndex.setValue(id, index);
        } else {
            this.positionIndex.setValue(id, 0L);
        }
        if (this.searchIndex != null) {
            if (!update && (value == null || value.isEmpty())) {
                return;
            }
            String textValue = value == null ? "" : value;
            this.searchIndex.addValue(id, textValue, update);
        }
    }

    @Override
    public void writeTransactionValue(String value, DataOutputStream dataOutputStream) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.STRING.getId());
        dataOutputStream.writeInt(bytes.length);
        dataOutputStream.write(bytes);
    }

    @Override
    public String readTransactionValue(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        byte[] bytes = new byte[length];
        dataInputStream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public BitSet filter(BitSet records, TextFilter textFilter) {
        return this.filter(records, textFilter, true);
    }

    @Override
    public void close() {
        if (this.searchIndex != null) {
            this.searchIndex.commit(true);
        }
        this.positionIndex.close();
        this.charIndex.close();
    }

    @Override
    public void drop() {
        if (this.searchIndex != null) {
            this.searchIndex.drop();
        }
        this.positionIndex.drop();
        this.charIndex.drop();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            String value1 = this.getValue(o1.getLeafId());
            String value2 = this.getValue(o2.getLeafId());
            if (value1 == null || value2 == null) {
                if (value1 == null && value2 == null) {
                    return 0;
                }
                if (value1 == null) {
                    return -1 * order;
                }
                return order;
            }
            return value1.compareToIgnoreCase(value2);
        });
        return sortEntries;
    }

    public BitSet filter(BitSet records, TextFilter textFilter, boolean performLocalFullTextSearch) {
        BitSet fullTextResult = records;
        if (performLocalFullTextSearch && textFilter.getFilterType().containsFullTextPart()) {
            if (this.searchIndex != null) {
                fullTextResult = this.searchIndex.filter(records, textFilter);
            } else if (this.collectionSearchIndex != null) {
                fullTextResult = this.collectionSearchIndex.filter(records, Collections.singletonList(TextFieldFilter.create(textFilter, this.getName())), true);
            } else {
                return null;
            }
            if (!textFilter.getFilterType().containsIndexPart()) {
                return fullTextResult;
            }
        }
        if (textFilter.getFilterType().containsIndexPart()) {
            switch (textFilter.getFilterType()) {
                case EMPTY: {
                    return this.filterEmpty(records);
                }
                case NOT_EMPTY: {
                    return this.filterNotEmpty(records);
                }
                case TEXT_EQUALS: {
                    return this.filterEquals(fullTextResult, textFilter.getValue());
                }
                case TEXT_EQUALS_IGNORE_CASE: {
                    return this.filterEqualsIgnoreCase(fullTextResult, textFilter.getValue());
                }
                case TEXT_NOT_EQUALS: {
                    return this.filterNotEquals(fullTextResult, textFilter.getValue());
                }
                case TEXT_BYTE_LENGTH_GREATER: {
                    return this.filterLengthGreater(records, Integer.parseInt(textFilter.getValue()));
                }
                case TEXT_BYTE_LENGTH_SMALLER: {
                    return this.filterLengthSmaller(records, Integer.parseInt(textFilter.getValue()));
                }
            }
            return null;
        }
        return null;
    }

    public BitSet filterEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.positionIndex.getValue(id);
            if (index == 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.positionIndex.getValue(id);
            if (index != 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthGreater(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int textByteLength;
            long index = this.positionIndex.getValue(id);
            if (index > 0L && (textByteLength = this.charIndex.getTextByteLength(index)) > length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthSmaller(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int textByteLength;
            long index = this.positionIndex.getValue(id);
            if (index > 0L && (textByteLength = this.charIndex.getTextByteLength(index)) < length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterEquals(BitSet bitSet, String value) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            String text = this.getValue(id);
            if (Objects.equals(text, value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterEqualsIgnoreCase(BitSet bitSet, String value) {
        BitSet result = new BitSet();
        if (value == null) {
            return result;
        }
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            String text = this.getValue(id);
            if (value.equalsIgnoreCase(text)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterNotEquals(BitSet bitSet, String value) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            String text = this.getValue(id);
            if (!Objects.equals(text, value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

