/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.EntityArrayIterator;
import org.teamapps.universaldb.record.EntityBuilder;

public class EntityArrayList<ENTITY>
implements List<ENTITY> {
    private final EntityBuilder<ENTITY> entityBuilder;
    private PrimitiveIterator.OfInt recordIdIterator;
    private final int count;
    private int[] recordIds;

    public EntityArrayList(EntityBuilder<ENTITY> entityBuilder, PrimitiveIterator.OfInt recordIdIterator, int count) {
        this.entityBuilder = entityBuilder;
        this.recordIdIterator = recordIdIterator;
        this.count = count;
        int pos = 0;
        this.recordIds = new int[count];
        while (recordIdIterator.hasNext()) {
            this.recordIds[pos] = recordIdIterator.nextInt();
            ++pos;
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<ENTITY> iterator() {
        return new EntityArrayIterator<ENTITY>(this.entityBuilder, this.recordIds);
    }

    @Override
    public Object[] toArray() {
        ArrayList<ENTITY> list = new ArrayList<ENTITY>();
        for (int id : this.recordIds) {
            list.add(this.entityBuilder.build(id));
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<ENTITY> list = new ArrayList<ENTITY>();
        for (int id : this.recordIds) {
            list.add(this.entityBuilder.build(id));
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(ENTITY entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.indexOf(o) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ENTITY> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends ENTITY> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ENTITY get(int index) {
        return this.entityBuilder.build(this.recordIds[index]);
    }

    @Override
    public ENTITY set(int index, ENTITY element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, ENTITY element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ENTITY remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        Entity entity = (Entity)o;
        int id = entity.getId();
        for (int i = 0; i < this.recordIds.length; ++i) {
            if (this.recordIds[i] != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<ENTITY> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<ENTITY> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ENTITY> subList(int fromIndex, int toIndex) {
        return this.stream().skip(fromIndex).limit(toIndex - fromIndex).collect(Collectors.toList());
    }
}

