/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionReader
implements Iterator<ClusterTransaction> {
    private final File transactionFile;
    private final DataBaseMapper dataBaseMapper;
    private boolean hasNext;
    private final DataInputStream dataInputStream;
    private int currentFilePos = 8;

    public TransactionReader(File transactionFile, DataBaseMapper dataBaseMapper) throws IOException {
        this.transactionFile = transactionFile;
        this.dataInputStream = transactionFile.getName().endsWith("z") ? new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(transactionFile)))) : new DataInputStream(new BufferedInputStream(new FileInputStream(transactionFile)));
        this.dataBaseMapper = dataBaseMapper;
        this.dataInputStream.readLong();
        int nextPacket = this.dataInputStream.read();
        this.hasNext = nextPacket > 0;
    }

    private boolean hasMoreTransactions(int filePos, int size) {
        return 1L + (long)filePos + (long)size < Integer.MAX_VALUE;
    }

    private ClusterTransaction readTransaction() {
        try {
            int size = this.dataInputStream.readInt();
            byte[] bytes = new byte[size];
            this.dataInputStream.read(bytes);
            TransactionPacket packet = new TransactionPacket(bytes);
            ClusterTransaction transaction = new ClusterTransaction(packet, this.dataBaseMapper);
            this.hasNext = this.hasMoreTransactions(this.currentFilePos, size + 5);
            if (this.hasNext) {
                int nextPacket = this.dataInputStream.read();
                this.hasNext = nextPacket > 0;
            }
            return transaction;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public ClusterTransaction next() {
        return this.readTransaction();
    }
}

