/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.translation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teamapps.universaldb.util.DataStreamUtil;

public class TranslatableText {
    private static final String DELIMITER = "\n<=@#!=>\n";
    private String originalText;
    private String originalLanguage;
    private String encodedValue;
    private Map<String, String> translationMap;

    public static TranslatableText create(String originalText, String originalLanguage) {
        return new TranslatableText(originalText, originalLanguage);
    }

    public TranslatableText() {
    }

    public TranslatableText(String originalText, String originalLanguage) {
        this.originalText = originalText;
        this.originalLanguage = originalLanguage;
    }

    public TranslatableText(String encodedValue) {
        if (!(encodedValue == null || encodedValue.startsWith(DELIMITER) && encodedValue.endsWith(DELIMITER))) {
            throw new RuntimeException("Error: invalid translation encoding:" + encodedValue);
        }
        this.encodedValue = encodedValue;
    }

    public TranslatableText(DataInputStream dataInputStream) throws IOException {
        this.encodedValue = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
    }

    public TranslatableText(String originalText, String originalLanguage, Map<String, String> translationMap) {
        if (translationMap.keySet().stream().anyMatch(s -> s.length() != 2)) {
            throw new RuntimeException("Error: invalid translation map");
        }
        this.originalText = originalText;
        this.originalLanguage = originalLanguage;
        this.translationMap = translationMap;
    }

    public String getText() {
        if (this.originalText == null) {
            this.parseOriginalValue();
        }
        return this.originalText;
    }

    public String getOriginalLanguage() {
        if (this.originalLanguage == null) {
            this.parseOriginalValue();
        }
        return this.originalLanguage;
    }

    public String getText(String language) {
        String translation = this.getTranslation(language);
        return translation != null ? translation : this.getText();
    }

    public String getText(List<String> rankedLanguages) {
        String translation = this.getTranslation(rankedLanguages);
        return translation != null ? translation : this.getText();
    }

    public String getTranslation(String language) {
        if (this.translationMap != null) {
            if (language.equals(this.originalLanguage)) {
                return this.originalText;
            }
            return this.translationMap.get(language);
        }
        return this.translationLookup(language);
    }

    public String getTranslation(List<String> rankedLanguages) {
        for (String language : rankedLanguages) {
            String translation = this.getTranslation(language);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    public TranslatableText setTranslation(String translation, String language) {
        if (translation == null || translation.isEmpty() || language == null || language.length() != 2) {
            return this;
        }
        this.getTranslationMap().put(language, translation);
        return this;
    }

    public String translationLookup(String language) {
        return this.findTranslation(language);
    }

    public String getEncodedValue() {
        if (this.translationMap != null || this.originalText != null) {
            return TranslatableText.createTranslationValue(this.originalText, this.originalLanguage, this.translationMap);
        }
        return this.encodedValue;
    }

    private void parseOriginalValue() {
        int end;
        if (this.encodedValue == null) {
            return;
        }
        int pos = -1;
        if ((pos = this.encodedValue.indexOf(DELIMITER, pos + 1)) >= 0 && pos < this.encodedValue.length() - DELIMITER.length() && (end = this.encodedValue.indexOf(DELIMITER, pos + 1)) > pos) {
            this.originalLanguage = this.encodedValue.substring(pos + DELIMITER.length(), pos + DELIMITER.length() + 2);
            this.originalText = this.encodedValue.substring(pos + DELIMITER.length() + 3, end);
        }
    }

    private String findTranslation(String language) {
        if (this.encodedValue == null || language == null || language.length() != 2) {
            return null;
        }
        if (language.equalsIgnoreCase(this.originalLanguage)) {
            return this.originalText;
        }
        int pos = -1;
        char a = language.charAt(0);
        char b = language.charAt(1);
        while ((pos = this.encodedValue.indexOf(DELIMITER, pos + 1)) >= 0 && pos < this.encodedValue.length() - DELIMITER.length()) {
            int end;
            if (this.encodedValue.charAt(pos + DELIMITER.length()) != a || this.encodedValue.charAt(pos + DELIMITER.length() + 1) != b || (end = this.encodedValue.indexOf(DELIMITER, pos + 1)) <= pos) continue;
            return this.encodedValue.substring(pos + DELIMITER.length() + 3, end);
        }
        return null;
    }

    public void writeValues(DataOutputStream dataOutputStream) throws IOException {
        String encodedValue = this.getEncodedValue();
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, encodedValue);
    }

    public Map<String, String> getTranslationMap() {
        if (this.translationMap != null) {
            return this.translationMap;
        }
        this.translationMap = this.encodedValue != null ? this.parseEncodedTranslation(this.encodedValue) : new HashMap();
        return this.translationMap;
    }

    private Map<String, String> parseEncodedTranslation(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        int pos = -1;
        while ((pos = text.indexOf(DELIMITER, pos + 1)) >= 0 && pos < text.length() - DELIMITER.length()) {
            int end = text.indexOf(DELIMITER, pos + 1);
            if (end <= pos) continue;
            String language = text.substring(pos + DELIMITER.length(), pos + DELIMITER.length() + 2);
            String value = text.substring(pos + DELIMITER.length() + 3, end);
            map.put(language, value);
            pos = end - 1;
        }
        return map;
    }

    private static String createTranslationValue(String originalText, String originalLanguage, Map<String, String> translationsByLanguage) {
        StringBuilder sb = new StringBuilder();
        if (originalText != null && originalLanguage != null) {
            sb.append(DELIMITER).append(originalLanguage).append(":").append(originalText);
        }
        if (translationsByLanguage != null) {
            for (Map.Entry<String, String> entry : translationsByLanguage.entrySet()) {
                sb.append(DELIMITER).append(entry.getKey()).append(":").append(entry.getValue());
            }
        }
        sb.append(DELIMITER);
        return sb.toString();
    }
}

