/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.translation;

import org.teamapps.universaldb.index.text.TextFilterType;

public class TranslatableTextFilter {
    private final TextFilterType filterType;
    private final String value;
    private final String language;

    public static TranslatableTextFilter emptyFilter(String language) {
        return new TranslatableTextFilter(TextFilterType.EMPTY, null, language);
    }

    public static TranslatableTextFilter notEmptyFilter(String language) {
        return new TranslatableTextFilter(TextFilterType.NOT_EMPTY, null, language);
    }

    public static TranslatableTextFilter textEqualsFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TEXT_EQUALS, value, language);
    }

    public static TranslatableTextFilter textNotEqualsFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TEXT_NOT_EQUALS, value, language);
    }

    public static TranslatableTextFilter textByteLengthGreaterFilter(int size, String language) {
        return new TranslatableTextFilter(TextFilterType.TEXT_BYTE_LENGTH_GREATER, "" + size, language);
    }

    public static TranslatableTextFilter textByteLengthSmallerFilter(int size, String language) {
        return new TranslatableTextFilter(TextFilterType.TEXT_BYTE_LENGTH_SMALLER, "" + size, language);
    }

    public static TranslatableTextFilter termEqualsFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_EQUALS, value, language);
    }

    public static TranslatableTextFilter termNotEqualsFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_NOT_EQUALS, value, language);
    }

    public static TranslatableTextFilter termStartsWithFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_STARTS_WITH, value, language);
    }

    public static TranslatableTextFilter termStartsNotWithFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_STARTS_NOT_WITH, value, language);
    }

    public static TranslatableTextFilter termSimilarFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_SIMILAR, value, language);
    }

    public static TranslatableTextFilter termNotSimilarFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_NOT_SIMILAR, value, language);
    }

    public static TranslatableTextFilter termContainsFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_CONTAINS, value, language);
    }

    public static TranslatableTextFilter termContainsNotFilter(String value, String language) {
        return new TranslatableTextFilter(TextFilterType.TERM_CONTAINS_NOT, value, language);
    }

    protected TranslatableTextFilter(TextFilterType filterType, String value, String language) {
        this.filterType = filterType;
        this.value = value;
        this.language = language;
    }

    public TextFilterType getFilterType() {
        return this.filterType;
    }

    public String getValue() {
        return this.value;
    }

    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return this.filterType + ":" + this.value;
    }
}

