/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.EntityChangeSet;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public abstract class AbstractUdbEntity<ENTITY extends Entity>
implements Entity<ENTITY> {
    private static final Logger log = LoggerFactory.getLogger(AbstractUdbEntity.class);
    private static final AtomicInteger correlationIdGenerator = new AtomicInteger();
    private static final int MAX_CORRELATION_ID = 2000000000;
    private int id;
    private boolean createEntity;
    private int correlationId;
    private EntityChangeSet entityChangeSet;
    private Transaction transaction;

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, List<ENTITY> list, String sortFieldName, boolean ascending, String ... path) {
        return AbstractUdbEntity.sort(table, list, sortFieldName, ascending, null, path);
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, List<ENTITY> list, String sortFieldName, boolean ascending, Locale locale, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        List<SortEntry> sortEntries = SortEntry.createSortEntries(list, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, locale);
        return sortEntries.stream().map(SortEntry::getEntity).collect(Collectors.toList());
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, EntityBuilder<ENTITY> builder, BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return AbstractUdbEntity.sort(table, builder, recordIds, sortFieldName, ascending, null, path);
    }

    public static <ENTITY extends Entity> List<ENTITY> sort(TableIndex table, EntityBuilder<ENTITY> builder, BitSet recordIds, String sortFieldName, boolean ascending, Locale locale, String ... path) {
        SingleReferenceIndex[] referencePath = AbstractUdbEntity.getReferenceIndices(table, path);
        ColumnIndex column = AbstractUdbEntity.getSortColumn(table, sortFieldName, referencePath);
        List<SortEntry> sortEntries = SortEntry.createSortEntries(recordIds, referencePath);
        sortEntries = column.sortRecords(sortEntries, ascending, locale);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (SortEntry entry : sortEntries) {
            list.add((Entity)builder.build(entry.getId()));
        }
        return list;
    }

    private static SingleReferenceIndex[] getReferenceIndices(TableIndex table, String[] path) {
        SingleReferenceIndex[] referencePath = null;
        if (path != null && path.length > 0) {
            referencePath = new SingleReferenceIndex[path.length];
            TableIndex pathTable = table;
            for (int i = 0; i < path.length; ++i) {
                referencePath[i] = (SingleReferenceIndex)pathTable.getColumnIndex(path[i]);
                pathTable = referencePath[i].getReferencedTable();
            }
        }
        return referencePath;
    }

    private static ColumnIndex getSortColumn(TableIndex table, String sortFieldName, SingleReferenceIndex[] referencePath) {
        ColumnIndex column = referencePath != null && referencePath.length > 0 ? referencePath[referencePath.length - 1].getReferencedTable().getColumnIndex(sortFieldName) : table.getColumnIndex(sortFieldName);
        return column;
    }

    public AbstractUdbEntity() {
        this.createEntity = true;
        this.createCorrelationId();
    }

    public AbstractUdbEntity(int id, boolean createEntity) {
        this.id = id;
        this.createEntity = createEntity;
        if (createEntity) {
            this.createCorrelationId();
        }
    }

    private void createCorrelationId() {
        if (this.correlationId > 0) {
            return;
        }
        this.correlationId = correlationIdGenerator.incrementAndGet();
        if (this.correlationId == 2000000000) {
            correlationIdGenerator.set(0);
        }
    }

    @Override
    public int getId() {
        if (this.id == 0 && this.transaction != null) {
            this.id = this.transaction.getResolvedRecordIdByCorrelationId(this.correlationId);
        }
        return this.id;
    }

    protected int getCorrelationId() {
        return this.correlationId;
    }

    protected void setChangeValue(ColumnIndex index, Object value, TableIndex tableIndex) {
        this.checkChangeSet();
        this.entityChangeSet.addChangeValue(index, value);
    }

    protected void setSingleReferenceValue(ColumnIndex index, Entity reference, TableIndex tableIndex) {
        AbstractUdbEntity entity = (AbstractUdbEntity)reference;
        RecordReference recordReference = null;
        if (entity != null) {
            recordReference = new RecordReference(entity.getId(), entity.getCorrelationId());
        }
        this.checkChangeSet();
        this.entityChangeSet.addChangeValue(index, recordReference);
        this.entityChangeSet.setReferenceChange(index, entity);
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(ColumnIndex index, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        TransactionRecordValue changeValue = this.getChangeValue(index);
        MultiReferenceEditValue editValue = (MultiReferenceEditValue)changeValue.getValue();
        MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)index;
        PrimitiveIterator.OfInt references = multiReferenceIndex.getReferences(this.getId());
        return this.createEntityList(editValue, references, entityBuilder);
    }

    protected <OTHER_ENTITY extends Entity> List<OTHER_ENTITY> createEntityList(MultiReferenceEditValue editValue, PrimitiveIterator.OfInt referenceIterator, EntityBuilder<OTHER_ENTITY> entityBuilder) {
        Map<RecordReference, Entity> entityByReference = this.entityChangeSet.getEntityByReference();
        ArrayList<Entity<Object>> list = new ArrayList<Entity<Object>>();
        if (!editValue.getSetReferences().isEmpty() || editValue.isRemoveAll()) {
            List<RecordReference> references = editValue.isRemoveAll() ? editValue.getAddReferences() : editValue.getSetReferences();
            references.forEach(reference -> {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity == null && reference.getRecordId() > 0) {
                    entity = (Entity)entityBuilder.build(reference.getRecordId());
                }
                if (entity != null) {
                    list.add(entity);
                } else {
                    log.error("Cannot add reference to list: no record id and no matching correlation id!");
                }
            });
            return list;
        }
        HashSet removeSet = new HashSet();
        editValue.getRemoveReferences().forEach(reference -> {
            if (reference.getRecordId() > 0) {
                removeSet.add(reference.getRecordId());
            } else {
                Entity entity = (Entity)entityByReference.get(reference);
                if (entity != null) {
                    removeSet.add(entity.getId());
                }
            }
        });
        ArrayList addEntities = new ArrayList();
        editValue.getAddReferences().forEach(reference -> {
            Entity entity = (Entity)entityByReference.get(reference);
            if (entity == null && reference.getRecordId() > 0) {
                entity = (Entity)entityBuilder.build(reference.getRecordId());
            }
            if (entity != null) {
                addEntities.add(entity);
            }
        });
        HashSet addEntitySet = new HashSet();
        addEntities.forEach(entity -> addEntitySet.add(entity.getId()));
        if (referenceIterator != null) {
            while (referenceIterator.hasNext()) {
                int recordId = referenceIterator.nextInt();
                if (removeSet.contains(recordId) || addEntitySet.contains(recordId)) continue;
                list.add((Entity)entityBuilder.build(recordId));
            }
        }
        list.addAll(addEntities);
        return list;
    }

    protected TransactionRecordValue getChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index);
    }

    protected Object getChangedValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getChangeValue(index).getValue();
    }

    protected AbstractUdbEntity getReferenceChangeValue(ColumnIndex index) {
        if (this.entityChangeSet == null) {
            return null;
        }
        return this.entityChangeSet.getReferenceChange(index);
    }

    protected void addMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex, TableIndex tableIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex, tableIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.addReferences(references);
    }

    protected void removeMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex, TableIndex tableIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex, tableIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.removeReferences(references);
    }

    protected void setMultiReferenceValue(List<? extends Entity> entities, MultiReferenceIndex multiReferenceIndex, TableIndex tableIndex) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex, tableIndex);
        List<RecordReference> references = this.createRecordReferences(entities);
        editValue.setReferences(references);
    }

    protected void removeAllMultiReferenceValue(MultiReferenceIndex multiReferenceIndex, TableIndex tableIndex) {
        MultiReferenceEditValue editValue = this.getOrCreateMultiReferenceEditValue(multiReferenceIndex, tableIndex);
        editValue.setRemoveAll();
    }

    private List<RecordReference> createRecordReferences(List<? extends Entity> entities) {
        ArrayList<RecordReference> references = new ArrayList<RecordReference>();
        for (Entity entity : entities) {
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            RecordReference recordReference = new RecordReference(udbEntity.getId(), udbEntity.getCorrelationId());
            references.add(recordReference);
            this.entityChangeSet.addRecordReference(recordReference, entity);
        }
        return references;
    }

    private MultiReferenceEditValue getOrCreateMultiReferenceEditValue(MultiReferenceIndex multiReferenceIndex, TableIndex tableIndex) {
        MultiReferenceEditValue editValue;
        TransactionRecordValue changeValue = this.getChangeValue(multiReferenceIndex);
        if (changeValue != null) {
            editValue = (MultiReferenceEditValue)changeValue.getValue();
        } else {
            editValue = new MultiReferenceEditValue();
            this.setChangeValue(multiReferenceIndex, editValue, tableIndex);
        }
        return editValue;
    }

    protected boolean isChanged(ColumnIndex index) {
        return this.entityChangeSet != null && this.entityChangeSet.isChanged(index);
    }

    protected int getEntityId(Entity entity) {
        if (entity == null) {
            return 0;
        }
        return entity.getId();
    }

    protected Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void clearChanges() {
        this.entityChangeSet = null;
    }

    @Override
    public boolean isModified() {
        return this.entityChangeSet != null;
    }

    private void checkChangeSet() {
        if (this.entityChangeSet == null) {
            this.entityChangeSet = new EntityChangeSet();
            this.createCorrelationId();
        }
    }

    public void save(Transaction transaction, TableIndex tableIndex, boolean strictChangeVerification) {
        if (this.entityChangeSet != null) {
            this.transaction = transaction;
            boolean update = !this.createEntity;
            TransactionRecord transactionRecord = new TransactionRecord(tableIndex, this.id, this.correlationId, transaction.getUserId(), update, false, strictChangeVerification);
            this.entityChangeSet.setTransactionRecordValues(transaction, transactionRecord, strictChangeVerification);
            transaction.addTransactionRecord(transactionRecord);
            this.clearChanges();
        }
    }

    public void save(TableIndex tableIndex) {
        if (this.entityChangeSet != null) {
            this.transaction = Transaction.create();
            this.save(this.transaction, tableIndex, false);
            this.transaction.execute();
            if (this.id == 0) {
                this.id = this.transaction.getResolvedRecordIdByCorrelationId(this.correlationId);
            }
        }
    }

    protected TableIndex retrieveTableIndex() {
        if (this.entityChangeSet != null) {
            return this.entityChangeSet.retrieveTableIndex();
        }
        return null;
    }

    public void delete(Transaction transaction, TableIndex tableIndex) {
        TransactionRecord transactionRecord = new TransactionRecord(tableIndex, this.id, 0, transaction.getUserId(), true);
        transaction.addTransactionRecord(transactionRecord);
        this.clearChanges();
    }

    public void delete(TableIndex tableIndex) {
        Transaction transaction = Transaction.create();
        this.delete(transaction, tableIndex);
        transaction.execute();
    }

    @Override
    public boolean isCommitted() {
        return this.entityChangeSet == null;
    }

    @Override
    public boolean isStored() {
        return this.id > 0 && !this.createEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractUdbEntity that = (AbstractUdbEntity)o;
        if (this.getId() > 0 && this.getId() == that.getId()) {
            return true;
        }
        return this.getCorrelationId() > 0 && this.getCorrelationId() == that.getCorrelationId();
    }

    public int hashCode() {
        if (this.getId() > 0) {
            return this.getId();
        }
        return this.getCorrelationId();
    }
}

