/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.io.IOException;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.TransactionPacket;
import org.teamapps.universaldb.transaction.TransactionRequest;

public class UnresolvedTransactionRequest
implements ClusterMessage {
    private final TransactionRequest transactionRequest;
    private final byte[] data;

    public UnresolvedTransactionRequest(TransactionRequest transactionRequest) throws IOException {
        this.transactionRequest = transactionRequest;
        this.data = transactionRequest.getPacket().writePacketBytes();
    }

    public UnresolvedTransactionRequest(byte[] data, DataBaseMapper dataBaseMapper) throws IOException {
        this.data = data;
        TransactionPacket transactionPacket = new TransactionPacket(data);
        this.transactionRequest = new TransactionRequest(transactionPacket, dataBaseMapper);
    }

    public TransactionRequest getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    public MessageType getType() {
        return MessageType.UNRESOLVED_TRANSACTION;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

