/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.distribute.PacketDataMingling;
import org.teamapps.universaldb.distribute.TransactionMessageKey;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionHead
extends LeaderSelectorListenerAdapter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LEADER_SELECTION_NODE = "/leaderSelection/leader";
    private final String clientId;
    private final String sharedSecret;
    private final DataBaseMapper dataBaseMapper;
    private final TransactionIdProvider transactionIdProvider;
    private final Consumer<byte[], byte[]> consumer;
    private final KafkaProducer<byte[], byte[]> producer;
    private final LeaderSelector leaderSelector;
    private final String consumerTopic;
    private final TopicPartition consumerTopicPartition;
    private final String producerTopic;

    public TransactionHead(String zookeeperConfig, String brokerConfig, String clientId, String groupId, String sharedSecret, String topicPrefix, DataBaseMapper dataBaseMapper, TransactionIdProvider transactionIdProvider) {
        this.clientId = clientId;
        this.sharedSecret = sharedSecret;
        this.dataBaseMapper = dataBaseMapper;
        this.transactionIdProvider = transactionIdProvider;
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerConfig);
        consumerProps.put("group.id", groupId);
        consumerProps.put("group.instance.id", groupId);
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("max.poll.records", (Object)10000);
        consumerProps.put("enable.auto.commit", "true");
        consumerProps.put("auto.offset.reset", "earliest");
        this.consumerTopic = topicPrefix + "-unresolved";
        this.consumerTopicPartition = new TopicPartition(this.consumerTopic, 0);
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumer.subscribe(Collections.singletonList(this.consumerTopic));
        this.producerTopic = topicPrefix + "-resolved";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerConfig);
        producerProps.put("client.id", clientId);
        producerProps.put("key.serializer", ByteArraySerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        this.producer = new KafkaProducer(producerProps);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)zookeeperConfig, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.leaderSelector = new LeaderSelector(client, LEADER_SELECTION_NODE, (LeaderSelectorListener)this);
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        logger.info("START TRANSACTION HEAD");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                this.handleMessages();
            }
        }
        finally {
            logger.info("END TRANSACTION HEAD");
        }
    }

    private void handleMessages() throws IOException {
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofSeconds(1L));
        List records = consumerRecords.records(this.consumerTopicPartition);
        for (ConsumerRecord record : records) {
            TransactionMessageKey messageKey = new TransactionMessageKey((byte[])record.key());
            byte[] value = (byte[])record.value();
            byte[] bytes = PacketDataMingling.mingle(value, this.sharedSecret, messageKey.getLocalKey());
            TransactionPacket transactionPacket = new TransactionPacket(bytes);
            ClusterTransaction transaction = new ClusterTransaction(transactionPacket, this.dataBaseMapper);
            messageKey.setHeadClientId(this.clientId);
            transactionPacket = transaction.resolveAndExecuteTransaction(this.transactionIdProvider, transactionPacket);
            if (transactionPacket != null) {
                this.producer.send(new ProducerRecord(this.producerTopic, (Object)messageKey.getBytes(), (Object)transactionPacket.writePacketBytes()));
                continue;
            }
            logger.info("Sending error packet...");
            this.producer.send(new ProducerRecord(this.producerTopic, (Object)messageKey.getBytes(), null));
        }
    }

    @Override
    public void close() throws IOException {
        this.leaderSelector.close();
    }
}

