/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.distribute.PacketDataMingling;
import org.teamapps.universaldb.distribute.TransactionExecutionResult;
import org.teamapps.universaldb.distribute.TransactionMessageKey;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionReader {
    public static final String RESOLVED_SUFFIX = "resolved";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String clientId;
    private final String sharedSecret;
    private final DataBaseMapper dataBaseMapper;
    private final Consumer<byte[], byte[]> consumer;
    private final String topic;
    private final TopicPartition topicPartition;
    private final Map<TransactionMessageKey, TransactionExecutionResult> transactionMap;
    private final TransactionIdProvider transactionIdProvider;

    public TransactionReader(String brokerConfig, String clientId, String groupId, String sharedSecret, String topicPrefix, DataBaseMapper dataBaseMapper, Map<TransactionMessageKey, TransactionExecutionResult> transactionMap, TransactionIdProvider transactionIdProvider) {
        this.clientId = clientId;
        this.sharedSecret = sharedSecret;
        this.dataBaseMapper = dataBaseMapper;
        this.transactionMap = transactionMap;
        this.transactionIdProvider = transactionIdProvider;
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerConfig);
        consumerProps.put("group.id", groupId);
        consumerProps.put("group.instance.id", groupId);
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("max.poll.records", (Object)10000);
        consumerProps.put("enable.auto.commit", "true");
        consumerProps.put("auto.offset.reset", "earliest");
        this.topic = topicPrefix + "-resolved";
        this.topicPartition = new TopicPartition(this.topic, 0);
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumer.subscribe(Collections.singletonList(this.topic));
    }

    private void start() {
        while (true) {
            try {
                while (true) {
                    this.consume();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void consume() throws IOException {
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofSeconds(1L));
        List records = consumerRecords.records(this.topicPartition);
        for (ConsumerRecord record : records) {
            TransactionMessageKey messageKey = new TransactionMessageKey((byte[])record.key());
            byte[] value = (byte[])record.value();
            byte[] bytes = PacketDataMingling.mingle(value, this.sharedSecret, messageKey.getLocalKey());
            TransactionPacket transactionPacket = new TransactionPacket(bytes);
            ClusterTransaction transaction = new ClusterTransaction(transactionPacket, this.dataBaseMapper);
            if (transaction.getTransactionId() == this.transactionIdProvider.getLastCommittedTransactionId() + 1L) {
                this.commitTransactions(transaction, messageKey);
                continue;
            }
            logger.warn("Transaction with wrong transaction id! Expected id:" + (this.transactionIdProvider.getLastCommittedTransactionId() + 1L) + ", actual id:" + transaction.getTransactionId() + ", key:");
        }
    }

    private void commitTransactions(ClusterTransaction transaction, TransactionMessageKey messageKey) {
        if (!this.clientId.equals(messageKey.getHeadClientId())) {
            transaction.executeResolvedTransaction();
        }
        if (messageKey.getClientId().equals(this.clientId)) {
            TransactionExecutionResult executionResult = this.transactionMap.remove(messageKey);
            executionResult.handleSuccess(transaction.getRecordIdByCorrelationId());
        }
    }
}

