/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.fileng;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileFilter;
import org.teamapps.universaldb.index.fileng.FileStore;
import org.teamapps.universaldb.index.fileng.FileTextContentIndex;
import org.teamapps.universaldb.index.fileng.FileUtil;
import org.teamapps.universaldb.index.fileng.FileValue;
import org.teamapps.universaldb.index.fileng.FileVersionDataIndex;
import org.teamapps.universaldb.index.fileng.FileVersionEntry;
import org.teamapps.universaldb.index.fileng.LocalStoreFileValue;
import org.teamapps.universaldb.index.fileng.RemoteFileStore;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.util.DataStreamUtil;

public class FileIndex
extends AbstractIndex<FileValue, FileFilter>
implements FileStore {
    private final TextIndex hashIndex;
    private final TextIndex nameIndex;
    private final LongIndex sizeIndex;
    private FileTextContentIndex textContentIndex;
    private ShortIndex versionIndex;
    private FileVersionDataIndex versionDataIndex;
    private final CollectionTextSearchIndex fullTextIndex;
    private final String filePath;
    private final boolean indexFileContent;
    private final boolean indexFileVersions;
    private final String secret;
    private final File localFileStorePath;
    private final RemoteFileStore remoteFileStore;

    public FileIndex(String name, TableIndex table, ColumnType columnType, boolean indexFileContent, boolean indexFileVersions, String secret) {
        super(name, table, columnType, indexFileContent ? FullTextIndexingOptions.INDEXED : FullTextIndexingOptions.NOT_INDEXED);
        this.indexFileContent = indexFileContent;
        this.indexFileVersions = indexFileVersions;
        this.secret = secret;
        this.hashIndex = new TextIndex(name + "-file-hash", table, columnType, false);
        this.nameIndex = new TextIndex(name + "-file-name", table, columnType, false);
        this.sizeIndex = new LongIndex(name + "-file-size", table, columnType);
        if (indexFileContent) {
            this.textContentIndex = new FileTextContentIndex(table.getPath(), name + "-file-fulltext-content");
        }
        if (indexFileVersions) {
            this.versionIndex = new ShortIndex(name + "-file-version", table, columnType);
            this.versionDataIndex = new FileVersionDataIndex(name, table);
        }
        this.fullTextIndex = new CollectionTextSearchIndex(this.getPath(), name);
        this.filePath = this.getFQN().replace('.', '/');
        this.localFileStorePath = new File(table.getPath(), name + "-file-store");
        this.remoteFileStore = null;
    }

    @Override
    public IndexType getType() {
        return IndexType.FILE_NG;
    }

    @Override
    public FileValue getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, FileValue value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    public void removeAllVersions(int id) {
        if (!this.indexFileVersions) {
            this.removeValue(id);
        }
    }

    public FileValue getValue(int id) {
        String hash = this.hashIndex.getValue(id);
        if (hash == null) {
            return null;
        }
        String filePath = this.getFilePath(hash);
        File localFile = this.getLocalFile(filePath);
        long size = this.getSize(id);
        if (localFile.exists() && localFile.length() == size) {
            return new LocalStoreFileValue(id, this, localFile);
        }
        if (this.remoteFileStore != null) {
            try {
                InputStream inputStream = this.remoteFileStore.getInputStream(filePath);
                FileUtil.decryptAndDecompress(inputStream, localFile, hash);
                return new LocalStoreFileValue(id, this, localFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void setValue(int id, FileValue value) {
        if (value == null) {
            String hash = this.hashIndex.getValue(id);
            if (this.indexFileVersions && hash != null) {
                String fileName = this.nameIndex.getValue(id);
                long size = this.sizeIndex.getValue(id);
                short version = this.versionIndex.getValue(id);
                this.versionDataIndex.addVersionEntry(id, version, hash, fileName, size);
            }
            this.hashIndex.setValue(id, null);
            this.nameIndex.setValue(id, null);
            this.sizeIndex.setValue(id, 0L);
        } else {
            String hash = value.getHash();
            String filePath = this.getFilePath(hash);
            File localFile = this.getLocalFile(filePath);
            if (!localFile.exists()) {
                try {
                    IOUtils.copy((InputStream)value.getInputStream(), (OutputStream)new BufferedOutputStream(new FileOutputStream(localFile)));
                    if (this.remoteFileStore != null) {
                        File tempFile = File.createTempFile("temp", ".bin");
                        FileUtil.encrypt(localFile, tempFile, hash);
                        this.remoteFileStore.setFile(filePath, tempFile);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error: could not write file to local store:" + filePath, e);
                }
            }
            this.nameIndex.setValue(id, value.getFileName());
            this.sizeIndex.setValue(id, value.getSize());
            if (this.indexFileVersions) {
                // empty if block
            }
            if (this.indexFileContent) {
                // empty if block
            }
            this.hashIndex.setValue(id, hash);
        }
    }

    private String getFilePath(String hash) {
        String pathHash = FileUtil.createHash(hash, this.secret);
        return this.filePath + pathHash.substring(0, 2) + "/" + pathHash + ".bin";
    }

    private File getLocalFile(String path) {
        return new File(this.localFileStorePath, path);
    }

    private void writeLocalFile(String path, FileValue value) throws IOException {
        File localFile = this.getLocalFile(path);
        if (localFile.exists()) {
            return;
        }
        localFile.getParentFile().mkdirs();
        try (BufferedOutputStream input = new BufferedOutputStream(new FileOutputStream(localFile), 65536);
             BufferedInputStream output = new BufferedInputStream(value.getInputStream(), 65536);){
            IOUtils.copy((InputStream)output, (OutputStream)input, (int)16384);
        }
    }

    @Override
    public String getHash(int id) {
        return this.hashIndex.getValue(id);
    }

    @Override
    public String getFileName(int id) {
        return this.nameIndex.getValue(id);
    }

    @Override
    public long getSize(int id) {
        return this.sizeIndex.getValue(id);
    }

    @Override
    public InputStream getInputStream(int id) {
        String hash = this.hashIndex.getValue(id);
        String filePath = this.getFilePath(hash);
        File localFile = this.getLocalFile(filePath);
        if (localFile.exists()) {
            try {
                return new FileInputStream(localFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public File getAsFile(int id) {
        String hash = this.hashIndex.getValue(id);
        String filePath = this.getFilePath(hash);
        File localFile = this.getLocalFile(filePath);
        if (localFile.exists()) {
            return localFile;
        }
        return null;
    }

    @Override
    public File getFileVersion(int id, int version) {
        String hash;
        String filePath;
        File localFile;
        FileVersionEntry versionData;
        if (this.indexFileVersions && (versionData = this.versionDataIndex.getVersionData(id, version)) != null && (localFile = this.getLocalFile(filePath = this.getFilePath(hash = versionData.getHash()))).exists()) {
            return localFile;
        }
        return null;
    }

    @Override
    public int getVersion(int id) {
        return this.indexFileVersions ? (int)this.versionIndex.getValue(id) : 0;
    }

    @Override
    public void writeTransactionValue(FileValue value, DataOutputStream dataOutputStream) throws IOException {
    }

    @Override
    public FileValue readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return null;
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        return null;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            String hash = this.hashIndex.getValue(id);
            if (hash != null) {
                String name = this.nameIndex.getValue(id);
                long size = this.sizeIndex.getValue(id);
                if (this.indexFileVersions) {
                    short value = this.versionIndex.getValue(id);
                    Map<Integer, FileVersionEntry> map = this.versionDataIndex.getVersions(id);
                }
                if (this.indexFileContent) {
                    this.textContentIndex.getEntryIterator();
                }
                dataOutputStream.writeInt(id);
                DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, hash);
                DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, name);
                dataOutputStream.writeLong(size);
            }
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            String hash = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            String name = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
            long l = dataInputStream.readLong();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, FileFilter fileFilter) {
        return null;
    }

    @Override
    public void close() {
        this.fullTextIndex.commit(true);
        this.hashIndex.close();
        this.nameIndex.close();
        this.sizeIndex.close();
        if (this.textContentIndex != null) {
            this.textContentIndex.close();
        }
        if (this.versionIndex != null) {
            this.versionIndex.close();
            this.versionDataIndex.close();
        }
    }

    @Override
    public void drop() {
        this.fullTextIndex.drop();
        this.hashIndex.drop();
        this.nameIndex.drop();
        this.sizeIndex.drop();
        if (this.textContentIndex != null) {
            this.textContentIndex.drop();
        }
        if (this.versionIndex != null) {
            this.versionIndex.drop();
            this.versionDataIndex.drop();
        }
    }
}

