/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster;

public enum ClusterNodeRole {
    STAND_ALONE(0),
    AUTO(1),
    HEAD(2),
    WORKER(3),
    SNAPSHOT_PROVIDER(4),
    TRANSACTION_LOGGER(5),
    REMOTE(6),
    EXTERNAL(7),
    EXTERNAL_SUBSET(8),
    SNAPSHOT_CONSUMER(9);

    private final int id;

    public static ClusterNodeRole getById(int id) {
        for (ClusterNodeRole value : ClusterNodeRole.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        return null;
    }

    private ClusterNodeRole(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public ClusterNodeRole getBootUpType() {
        switch (this) {
            case STAND_ALONE: {
                return STAND_ALONE;
            }
            case AUTO: 
            case HEAD: 
            case WORKER: {
                return AUTO;
            }
            case SNAPSHOT_PROVIDER: {
                return SNAPSHOT_PROVIDER;
            }
            case REMOTE: {
                return REMOTE;
            }
            case TRANSACTION_LOGGER: {
                return TRANSACTION_LOGGER;
            }
            case EXTERNAL: {
                return EXTERNAL;
            }
            case EXTERNAL_SUBSET: {
                return EXTERNAL_SUBSET;
            }
            case SNAPSHOT_CONSUMER: {
                return SNAPSHOT_CONSUMER;
            }
        }
        return null;
    }

    public boolean allowedToVoteForHeadSelection() {
        switch (this) {
            case AUTO: 
            case HEAD: 
            case WORKER: 
            case SNAPSHOT_PROVIDER: 
            case REMOTE: 
            case TRANSACTION_LOGGER: {
                return true;
            }
            case STAND_ALONE: 
            case EXTERNAL: 
            case EXTERNAL_SUBSET: 
            case SNAPSHOT_CONSUMER: {
                return false;
            }
        }
        return false;
    }

    public boolean allowedToBecomeHead() {
        switch (this) {
            case AUTO: 
            case HEAD: 
            case WORKER: {
                return true;
            }
            case STAND_ALONE: 
            case SNAPSHOT_PROVIDER: 
            case REMOTE: 
            case TRANSACTION_LOGGER: 
            case EXTERNAL: 
            case EXTERNAL_SUBSET: 
            case SNAPSHOT_CONSUMER: {
                return false;
            }
        }
        return false;
    }
}

