/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.teamapps.universaldb.cluster.ClusterNodeRole;
import org.teamapps.universaldb.cluster.ClusterOperationMode;
import org.teamapps.universaldb.cluster.message.ByteBufferUtil;
import org.teamapps.universaldb.cluster.message.ClusterMessage;
import org.teamapps.universaldb.cluster.network.MessageType;
import org.teamapps.universaldb.schema.Schema;

public class InitMessage
implements ClusterMessage {
    private final int nodeId;
    private final long lastTransactionId;
    private final long currentTransactionId;
    private final long transactionCount;
    private final Schema schema;
    private final ClusterOperationMode clusterOperationMode;
    private final ClusterNodeRole currentType;
    private final ClusterNodeRole preferredType;
    private final byte[] data;

    public InitMessage(int nodeId, long lastTransactionId, long currentTransactionId, long transactionCount, Schema schema, ClusterOperationMode clusterOperationMode, ClusterNodeRole currentType, ClusterNodeRole preferredType) throws IOException {
        this.nodeId = nodeId;
        this.lastTransactionId = lastTransactionId;
        this.currentTransactionId = currentTransactionId;
        this.transactionCount = transactionCount;
        this.schema = schema;
        this.clusterOperationMode = clusterOperationMode;
        this.currentType = currentType;
        this.preferredType = preferredType;
        byte[] schemaData = schema.getSchemaData();
        this.data = new byte[31 + schemaData.length + 4];
        ByteBuffer buffer = ByteBuffer.wrap(this.data);
        buffer.putInt(nodeId);
        buffer.putLong(lastTransactionId);
        buffer.putLong(currentTransactionId);
        buffer.putLong(transactionCount);
        ByteBufferUtil.putBytesWithHeader(schemaData, buffer);
        buffer.put((byte)clusterOperationMode.getId());
        buffer.put((byte)currentType.getId());
        buffer.put((byte)preferredType.getId());
    }

    public InitMessage(byte[] data) throws IOException {
        this.data = data;
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.nodeId = buffer.getInt();
        this.lastTransactionId = buffer.getLong();
        this.currentTransactionId = buffer.getLong();
        this.transactionCount = buffer.getLong();
        byte[] schemaBytes = ByteBufferUtil.getBytesWithHeader(buffer);
        this.schema = new Schema(schemaBytes);
        this.clusterOperationMode = ClusterOperationMode.getById(buffer.get());
        this.currentType = ClusterNodeRole.getById(buffer.get());
        this.preferredType = ClusterNodeRole.getById(buffer.get());
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public long getLastTransactionId() {
        return this.lastTransactionId;
    }

    public long getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public ClusterOperationMode getClusterOperationMode() {
        return this.clusterOperationMode;
    }

    public ClusterNodeRole getCurrentType() {
        return this.currentType;
    }

    public ClusterNodeRole getPreferredType() {
        return this.preferredType;
    }

    @Override
    public MessageType getType() {
        return MessageType.INITIAL_MESSAGE;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }
}

