/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.util.HashSet;
import java.util.Set;
import org.teamapps.universaldb.index.IndexType;

public enum ColumnType {
    BOOLEAN,
    BITSET_BOOLEAN,
    SHORT,
    INT,
    LONG,
    FLOAT,
    DOUBLE,
    TEXT,
    TRANSLATABLE_TEXT,
    FILE,
    SINGLE_REFERENCE,
    MULTI_REFERENCE,
    TIMESTAMP,
    DATE,
    TIME,
    DATE_TIME,
    LOCAL_DATE,
    ENUM,
    BINARY,
    CURRENCY,
    DYNAMIC_CURRENCY;


    public boolean isReference() {
        return this == SINGLE_REFERENCE || this == MULTI_REFERENCE;
    }

    public IndexType getIndexType() {
        switch (this) {
            case BOOLEAN: 
            case BITSET_BOOLEAN: {
                return IndexType.BOOLEAN;
            }
            case ENUM: 
            case SHORT: {
                return IndexType.SHORT;
            }
            case TIMESTAMP: 
            case TIME: 
            case INT: {
                return IndexType.INT;
            }
            case DATE: 
            case DATE_TIME: 
            case LOCAL_DATE: 
            case LONG: {
                return IndexType.LONG;
            }
            case FLOAT: {
                return IndexType.FLOAT;
            }
            case DOUBLE: {
                return IndexType.DOUBLE;
            }
            case TEXT: {
                return IndexType.TEXT;
            }
            case TRANSLATABLE_TEXT: {
                return IndexType.TRANSLATABLE_TEXT;
            }
            case FILE: {
                return IndexType.FILE;
            }
            case BINARY: {
                return IndexType.BINARY;
            }
            case SINGLE_REFERENCE: {
                return IndexType.REFERENCE;
            }
            case MULTI_REFERENCE: {
                return IndexType.MULTI_REFERENCE;
            }
        }
        return null;
    }

    public static Set<String> getNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (ColumnType value : ColumnType.values()) {
            nameSet.add(value.name());
        }
        return nameSet;
    }
}

