/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.file.FileStore;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.schema.Column;
import org.teamapps.universaldb.schema.Database;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.schema.Table;

public class SchemaIndex {
    private final Schema schema;
    private final File path;
    private final List<DatabaseIndex> databases;
    private FileStore fileStore;

    public SchemaIndex(Schema schema, File path) {
        this.schema = schema;
        this.path = path;
        this.databases = new ArrayList<DatabaseIndex>();
    }

    public File getPath() {
        return this.path;
    }

    public void addDataBase(DatabaseIndex database) {
        this.databases.add(database);
    }

    public List<DatabaseIndex> getDatabases() {
        return this.databases;
    }

    public DatabaseIndex getDatabase(String name) {
        return this.databases.stream().filter(db -> db.getName().equals(name)).findAny().orElse(null);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    public void merge(Schema schema) {
        if (!this.schema.isCompatibleWith(schema)) {
            throw new RuntimeException("Error: cannot merge incompatible schemas:" + this + " with " + schema);
        }
        Map<String, DatabaseIndex> databaseMap = this.databases.stream().collect(Collectors.toMap(DatabaseIndex::getName, db -> db));
        for (Database database : schema.getDatabases()) {
            DatabaseIndex localDatabase = databaseMap.get(database.getName());
            if (localDatabase == null) {
                localDatabase = new DatabaseIndex(this, database.getName());
                this.databases.add(localDatabase);
            }
            if (localDatabase.getMappingId() == 0) {
                localDatabase.setMappingId(database.getMappingId());
            }
            localDatabase.merge(database);
        }
        for (Database database : schema.getDatabases()) {
            for (Table table : database.getTables()) {
                for (Column column : table.getColumns()) {
                    if (column.getReferencedTable() == null) continue;
                    ColumnIndex columnIndex = this.getColumn(column);
                    TableIndex referencedTable = this.getTable(column.getReferencedTable());
                    ColumnIndex backReference = null;
                    if (column.getBackReference() != null) {
                        backReference = referencedTable.getColumnIndex(column.getBackReference());
                    }
                    if (columnIndex instanceof SingleReferenceIndex) {
                        SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)columnIndex;
                        singleReferenceIndex.setReferencedTable(referencedTable, backReference, column.isCascadeDeleteReferences());
                        continue;
                    }
                    MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                    multiReferenceIndex.setReferencedTable(referencedTable, backReference, column.isCascadeDeleteReferences());
                }
            }
        }
        this.schema.merge(schema);
    }

    public Column getColumn(ColumnIndex index) {
        String fqn = index.getFQN();
        for (Database database : this.schema.getDatabases()) {
            for (Table table : database.getTables()) {
                for (Column column : table.getColumns()) {
                    if (!(database.getName() + "." + table.getName() + "." + column.getName()).equals(fqn)) continue;
                    return column;
                }
            }
        }
        return null;
    }

    private TableIndex getTable(Table table) {
        Database database = table.getDatabase();
        DatabaseIndex databaseIndex = this.getDatabase(database.getName());
        return databaseIndex.getTable(table.getName());
    }

    private ColumnIndex getColumn(Column column) {
        Table table = column.getTable();
        TableIndex tableIndex = this.getTable(table);
        return tableIndex.getColumnIndex(column.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Schema").append("\n");
        for (DatabaseIndex database : this.databases) {
            sb.append(database.toString()).append("\n");
        }
        return sb.toString();
    }
}

