/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.file;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.teamapps.universaldb.index.file.AbstractFileStore;
import org.teamapps.universaldb.index.file.FileCache;
import org.teamapps.universaldb.index.file.FileUtil;

public class CachingS3FileStore
extends AbstractFileStore {
    private final File path;
    private final String bucketName;
    private final String url;
    private final String accessKey;
    private final String secretKey;
    private final FileCache fileCache;
    private final File tempDir;
    private MinioClient minioClient;
    private boolean cachingActive = true;

    public CachingS3FileStore(File tempPath, String bucketName, String url, String accessKey, String secretKey) {
        this.path = tempPath;
        this.bucketName = bucketName;
        this.url = url;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.fileCache = new FileCache(tempPath);
        this.tempDir = new File(tempPath, "temp");
        this.tempDir.mkdir();
        this.connect();
    }

    private void connect() {
        try {
            this.minioClient = new MinioClient(this.url, this.accessKey, this.secretKey);
            this.createBucket(this.bucketName);
        }
        catch (InvalidEndpointException | InvalidPortException e) {
            e.printStackTrace();
        }
    }

    public boolean createBucket(String bucket) {
        try {
            if (!this.minioClient.bucketExists(bucket)) {
                this.minioClient.makeBucket(bucket);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public File getFile(String path, String uuid, String hash) {
        try {
            String filePath = this.createFilePath(path, uuid);
            File file = null;
            if (this.cachingActive) {
                this.fileCache.getFile(filePath);
                if (file != null && file.exists()) {
                    return file;
                }
            }
            File tempFile = Files.createTempFile(this.tempDir.toPath(), "temp", ".bin", new FileAttribute[0]).toFile();
            this.minioClient.statObject(this.bucketName, filePath);
            this.minioClient.getObject(this.bucketName, filePath, tempFile.getPath());
            File cacheFile = this.cachingActive ? this.fileCache.createCacheFilePath(filePath) : File.createTempFile("temp", ".bin");
            FileUtil.decryptAndDecompress(tempFile, cacheFile, hash);
            if (this.cachingActive) {
                this.fileCache.putFinishedCacheFile(cacheFile, filePath);
            }
            tempFile.delete();
            return cacheFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setFile(String path, String uuid, String hash, File file) {
        try {
            String filePath = this.createFilePath(path, uuid);
            if (this.cachingActive) {
                this.fileCache.addFile(file, filePath);
            }
            File tempFile = Files.createTempFile(this.tempDir.toPath(), "temp", ".bin", new FileAttribute[0]).toFile();
            FileUtil.compressAndEncrypt(file, tempFile, hash);
            this.minioClient.putObject(this.bucketName, filePath, tempFile.getPath(), Long.valueOf(tempFile.length()), null, null, "application/octet-stream");
            tempFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeFile(String path, String uuid) {
        try {
            this.minioClient.removeObject(this.bucketName, this.createFilePath(path, uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean fileExists(String path, String uuid) {
        try {
            this.minioClient.statObject(this.bucketName, this.createFilePath(path, uuid));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String createFilePath(String path, String uuid) {
        return path + "/" + uuid + ".bin";
    }

    public boolean isCachingActive() {
        return this.cachingActive;
    }

    public void setCachingActive(boolean cachingActive) {
        this.cachingActive = cachingActive;
    }
}

