/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.numeric;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.numeric.NumericIndex;
import org.teamapps.universaldb.transaction.DataType;

public class LongIndex
extends AbstractBufferIndex<Long, NumericFilter>
implements NumericIndex {
    public static final int ENTRY_SIZE = 8;

    public LongIndex(String name, TableIndex tableIndex, ColumnType columnType) {
        super(name, tableIndex, columnType, FullTextIndexingOptions.NOT_INDEXED);
    }

    @Override
    protected int getEntrySize() {
        return 8;
    }

    @Override
    public IndexType getType() {
        return IndexType.LONG;
    }

    @Override
    public Long getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, Long value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0L);
    }

    public long getValue(int id) {
        if (id > this.getMaximumId()) {
            return 0L;
        }
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 8;
        return this.getBuffer(index).getLong(position, ByteOrder.LITTLE_ENDIAN);
    }

    public void setValue(int id, long value) {
        this.ensureBufferSize(id);
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 8;
        this.getBuffer(index).putLong(position, value, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void writeTransactionValue(Long value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.LONG.getId());
        dataOutputStream.writeLong(value);
    }

    @Override
    public Long readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readLong();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            long value1 = this.getValue(o1.getLeafId());
            long value2 = this.getValue(o2.getLeafId());
            return Long.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeLong(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            long value = dataInputStream.readLong();
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Long> set = new HashSet<Long>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.longValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().longValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().longValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().longValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().longValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().longValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().longValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().longValue(), numericFilter.getValue2().longValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().longValue(), numericFilter.getValue2().longValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, long compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, long start, long end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, long start, long end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Long> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Long> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

