/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.multi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.agrona.collections.IntHashSet;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBlockChain;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilter;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.MultiReferenceValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.index.reference.value.ReferenceIteratorValue;
import org.teamapps.universaldb.transaction.DataType;

public class MultiReferenceIndex
extends AbstractIndex<MultiReferenceValue, MultiReferenceFilter>
implements ReferenceIndex {
    private final LongIndex entryIndex;
    private final ReferenceBlockChain referenceBlockChain;
    private TableIndex referencedTable;
    private boolean cyclicReferences;
    private boolean cascadeDeleteReferences;
    private SingleReferenceIndex reverseSingleIndex;
    private MultiReferenceIndex reverseMultiIndex;

    public MultiReferenceIndex(String name, TableIndex table, ColumnType columnType, ReferenceBlockChain referenceBlockChain) {
        super(name, table, columnType, FullTextIndexingOptions.NOT_INDEXED);
        this.entryIndex = new LongIndex(name, table, columnType);
        this.referenceBlockChain = referenceBlockChain;
    }

    public void setReferencedTable(TableIndex referencedTable, ColumnIndex reverseIndex, boolean cascadeDeleteReferences) {
        this.referencedTable = referencedTable;
        if (reverseIndex != null) {
            if (reverseIndex instanceof SingleReferenceIndex) {
                this.reverseSingleIndex = (SingleReferenceIndex)reverseIndex;
            } else {
                this.reverseMultiIndex = (MultiReferenceIndex)reverseIndex;
            }
            this.cyclicReferences = true;
        }
        this.cascadeDeleteReferences = cascadeDeleteReferences;
    }

    @Override
    public IndexType getType() {
        return IndexType.MULTI_REFERENCE;
    }

    @Override
    public TableIndex getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public boolean isCascadeDeleteReferences() {
        return this.cascadeDeleteReferences;
    }

    @Override
    public ColumnIndex getReferencedColumn() {
        if (this.reverseSingleIndex != null) {
            return this.reverseSingleIndex;
        }
        return this.reverseMultiIndex;
    }

    @Override
    public MultiReferenceValue getGenericValue(int id) {
        PrimitiveIterator.OfInt references = this.getReferences(id);
        if (references == null) {
            return null;
        }
        return new ReferenceIteratorValue(references, this.getReferencesCount(id));
    }

    @Override
    public void setGenericValue(int id, MultiReferenceValue value) {
        switch (value.getType()) {
            case REFERENCE_ITERATOR: {
                break;
            }
            case EDIT_VALUE: {
                this.setReferenceEditValue(id, (MultiReferenceEditValue)value);
            }
        }
    }

    @Override
    public void removeValue(int id) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            this.referenceBlockChain.removeAll(index);
        }
    }

    public PrimitiveIterator.OfInt getReferences(int id) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            return this.referenceBlockChain.getReferences(index);
        }
        return null;
    }

    public boolean isEmpty(int id) {
        if (id == 0) {
            return true;
        }
        return this.entryIndex.getValue(id) <= 0L;
    }

    public int getReferencesCount(int id) {
        if (id == 0) {
            return 0;
        }
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            return this.referenceBlockChain.getReferencesCount(index);
        }
        return 0;
    }

    public List<Integer> getReferencesAsList(int id) {
        PrimitiveIterator.OfInt references = this.getReferences(id);
        if (references == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (references.hasNext()) {
            list.add(references.nextInt());
        }
        return list;
    }

    public IntHashSet getReferencesAsPrimitiveSet(int id) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            int referencesCount = this.referenceBlockChain.getReferencesCount(index);
            IntHashSet set = new IntHashSet(referencesCount);
            PrimitiveIterator.OfInt references = this.referenceBlockChain.getReferences(index);
            while (references.hasNext()) {
                set.add(references.nextInt());
            }
            return set;
        }
        return new IntHashSet();
    }

    public BitSet getReferencesAsBitSet(int id) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            BitSet bitSet = new BitSet();
            PrimitiveIterator.OfInt references = this.referenceBlockChain.getReferences(index);
            while (references.hasNext()) {
                bitSet.set(references.nextInt());
            }
            return bitSet;
        }
        return new BitSet();
    }

    public void setReferenceEditValue(int id, MultiReferenceEditValue editValue) {
        if (!editValue.getSetReferences().isEmpty()) {
            List<Integer> references = RecordReference.createRecordIdsList(editValue.getSetReferences());
            this.setReferences(id, references);
        } else if (editValue.isRemoveAll()) {
            this.removeAllReferences(id);
            if (!editValue.getAddReferences().isEmpty()) {
                List<Integer> references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                this.addReferences(id, references, false);
            }
        } else {
            List<Integer> references;
            if (!editValue.getRemoveReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getRemoveReferences());
                this.removeReferences(id, references, false);
            }
            if (!editValue.getAddReferences().isEmpty()) {
                references = RecordReference.createRecordIdsList(editValue.getAddReferences());
                this.addReferences(id, references, false);
            }
        }
    }

    public void setReferences(int id, List<Integer> references) {
        long index = this.entryIndex.getValue(id);
        long newIndex = this.referenceBlockChain.create(references);
        this.entryIndex.setValue(id, newIndex);
        if (this.cyclicReferences) {
            if (index > 0L) {
                ArrayList<Integer> addIds = new ArrayList<Integer>();
                ArrayList<Integer> removeIds = new ArrayList<Integer>();
                this.calculateChangedIds(index, references, addIds, removeIds);
                this.addCyclicReferences(id, addIds);
                this.removeCyclicReferences(id, removeIds);
            } else {
                this.addCyclicReferences(id, references);
            }
        }
        if (index > 0L) {
            this.referenceBlockChain.removeAll(index);
        }
    }

    public void addReferences(int id, List<Integer> references) {
        this.addReferences(id, references, false);
    }

    public void addReferences(int id, List<Integer> references, boolean cyclic) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            PrimitiveIterator.OfInt iterator = this.referenceBlockChain.getReferences(index);
            HashSet<Integer> addSet = new HashSet<Integer>();
            while (iterator.hasNext()) {
                int reference = iterator.nextInt();
                if (!addSet.contains(reference)) continue;
                references.remove(reference);
                addSet.add(reference);
            }
            index = this.referenceBlockChain.add(references, index);
        } else {
            index = this.referenceBlockChain.create(references);
        }
        this.entryIndex.setValue(id, index);
        if (this.cyclicReferences && !cyclic) {
            this.addCyclicReferences(id, references);
        }
    }

    public void removeReferences(int id, List<Integer> references) {
        this.removeReferences(id, references, false);
    }

    public void removeReferences(int id, List<Integer> references, boolean cyclic) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            index = this.referenceBlockChain.remove(new HashSet<Integer>(references), index);
            this.entryIndex.setValue(id, index);
        }
        if (this.cyclicReferences && !cyclic) {
            this.removeCyclicReferences(id, references);
        }
    }

    public void removeAllReferences(int id) {
        long index = this.entryIndex.getValue(id);
        if (index > 0L) {
            if (this.cyclicReferences) {
                PrimitiveIterator.OfInt oldReferences = this.referenceBlockChain.getReferences(index);
                ArrayList<Integer> removeReferences = new ArrayList<Integer>();
                while (oldReferences.hasNext()) {
                    removeReferences.add(oldReferences.next());
                }
                this.removeCyclicReferences(id, removeReferences);
            }
            this.referenceBlockChain.removeAll(index);
            this.entryIndex.setValue(id, 0L);
        }
    }

    private void addCyclicReferences(int id, List<Integer> references) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (previousValue > 0 && previousValue != id) {
                    this.removeReferences(previousValue, Collections.singletonList(reference), true);
                }
                this.reverseSingleIndex.setIndexValue(reference, id);
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.addReferences(reference, Collections.singletonList(id), true);
            }
        }
    }

    private void removeCyclicReferences(int id, List<Integer> references) {
        if (this.reverseSingleIndex != null) {
            for (Integer reference : references) {
                int previousValue = this.reverseSingleIndex.getValue(reference);
                if (id != previousValue) continue;
                this.reverseSingleIndex.setIndexValue(reference, 0);
            }
        } else {
            for (Integer reference : references) {
                this.reverseMultiIndex.removeReferences(reference, Collections.singletonList(id), true);
            }
        }
    }

    private void calculateChangedIds(long index, List<Integer> references, List<Integer> addIds, List<Integer> removeIds) {
        HashSet<Integer> referenceSet = new HashSet<Integer>(references);
        HashSet<Integer> ignoreIdSet = new HashSet<Integer>();
        PrimitiveIterator.OfInt oldReferences = this.referenceBlockChain.getReferences(index);
        while (oldReferences.hasNext()) {
            Integer recordId = oldReferences.next();
            if (referenceSet.contains(recordId)) {
                ignoreIdSet.add(recordId);
                continue;
            }
            removeIds.add(recordId);
        }
        for (Integer reference : references) {
            if (ignoreIdSet.contains(reference)) continue;
            addIds.add(reference);
        }
    }

    @Override
    public void writeTransactionValue(MultiReferenceValue value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.MULTI_REFERENCE.getId());
        dataOutputStream.writeInt(value.getType().getId());
        value.writeValues(dataOutputStream);
    }

    @Override
    public MultiReferenceValue readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return MultiReferenceValue.create(dataInputStream);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            int value1 = this.getReferencesCount(o1.getLeafId());
            int value2 = this.getReferencesCount(o2.getLeafId());
            return Integer.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            List<Integer> references = this.getReferencesAsList(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeInt(references.size());
            for (Integer reference : references) {
                dataOutputStream.writeInt(reference);
            }
            id = records.nextSetBit(id + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        boolean cyclicReferencesValue = this.cyclicReferences;
        this.cyclicReferences = false;
        try {
            int id = dataInputStream.readInt();
            int count = dataInputStream.readInt();
            ArrayList<Integer> references = new ArrayList<Integer>();
            for (int i = 0; i < count; ++i) {
                references.add(dataInputStream.readInt());
            }
            this.setReferences(id, references);
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.cyclicReferences = cyclicReferencesValue;
        }
    }

    @Override
    public BitSet filter(BitSet records, MultiReferenceFilter filter) {
        switch (filter.getType()) {
            case EQUALS: {
                return this.filterEquals(records, filter.getReferencesSet());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, filter.getReferencesSet());
            }
            case IS_EMPTY: {
                return this.filterIsEmpty(records);
            }
            case IS_NOT_EMPTY: {
                return this.filterIsNotEmpty(records);
            }
            case CONTAINS_ANY: {
                return this.filterContainsAny(records, filter.getReferencesSet());
            }
            case CONTAINS_NONE: {
                return this.filterContainsNone(records, filter.getReferencesSet());
            }
            case CONTAINS_ALL: {
                return this.filterContainsAll(records, filter.getReferencesSet());
            }
            case CONTAINS_ANY_NOT: {
                return this.filterContainsAnyNot(records, filter.getReferencesSet());
            }
            case ENTRY_COUNT_EQUALS: {
                return this.filterEntryCountEquals(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_GREATER: {
                return this.filterEntryCountGreater(records, filter.getCountFilter());
            }
            case ENTRY_COUNT_LESSER: {
                return this.filterEntryCountSmaller(records, filter.getCountFilter());
            }
        }
        return null;
    }

    @Override
    public void close() {
        this.entryIndex.close();
        this.referenceBlockChain.flush();
    }

    @Override
    public void drop() {
        this.entryIndex.drop();
        this.referenceBlockChain.drop();
    }

    public BitSet filterEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int referencesCount;
            long index = this.entryIndex.getValue(id);
            if (index > 0L && (referencesCount = this.referenceBlockChain.getReferencesCount(index)) == compareIds.size()) {
                PrimitiveIterator.OfInt references = this.referenceBlockChain.getReferences(index);
                boolean containsDifference = false;
                while (references.hasNext()) {
                    if (compareIds.contains(references.nextInt())) continue;
                    containsDifference = true;
                    break;
                }
                if (!containsDifference) {
                    result.set(id);
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index <= 0L) {
                result.set(id);
            } else {
                int referencesCount = this.referenceBlockChain.getReferencesCount(index);
                if (referencesCount != compareIds.size()) {
                    result.set(id);
                } else {
                    PrimitiveIterator.OfInt references = this.referenceBlockChain.getReferences(index);
                    boolean containsDifference = false;
                    while (references.hasNext()) {
                        if (compareIds.contains(references.nextInt())) continue;
                        containsDifference = true;
                        break;
                    }
                    if (containsDifference) {
                        result.set(id);
                    }
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index <= 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterIsNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index > 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsAny(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index > 0L) {
                PrimitiveIterator.OfInt references = this.referenceBlockChain.getReferences(index);
                while (references.hasNext()) {
                    if (!compareIds.contains(references.nextInt())) continue;
                    result.set(id);
                    break;
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterContainsNone(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = this.filterContainsAny(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, result);
    }

    public BitSet filterContainsAll(BitSet bitSet, Set<Integer> compareIds) {
        BitSet result = new BitSet();
        BitSet compareSet = new BitSet();
        compareIds.forEach(compareSet::set);
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index > 0L) {
                BitSet referencesAsBitSet = this.getReferencesAsBitSet(id);
                referencesAsBitSet.and(compareSet);
                if (referencesAsBitSet.equals(compareSet)) {
                    result.set(id);
                }
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsAnyNot(BitSet bitSet, Set<Integer> compareIds) {
        BitSet containsAll = this.filterContainsAll(bitSet, compareIds);
        return MultiReferenceIndex.negateInput(bitSet, containsAll);
    }

    public BitSet filterEntryCountEquals(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int referencesCount;
            long index = this.entryIndex.getValue(id);
            if (index > 0L && (referencesCount = this.referenceBlockChain.getReferencesCount(index)) == count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountGreater(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int referencesCount;
            long index = this.entryIndex.getValue(id);
            if (index > 0L && (referencesCount = this.referenceBlockChain.getReferencesCount(index)) > count) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterEntryCountSmaller(BitSet bitSet, int count) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.entryIndex.getValue(id);
            if (index > 0L) {
                int referencesCount = this.referenceBlockChain.getReferencesCount(index);
                if (referencesCount < count) {
                    result.set(id);
                }
            } else {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

