/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.reference.value.MultiReferenceEditValue;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.transaction.Transaction;
import org.teamapps.universaldb.transaction.TransactionRecord;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class EntityChangeSet {
    private final Map<Integer, TransactionRecordValue> changeMap = new HashMap<Integer, TransactionRecordValue>();
    private final Map<Integer, AbstractUdbEntity> changedReferenceMap = new HashMap<Integer, AbstractUdbEntity>();
    private final Map<RecordReference, Entity> entityByReference = new HashMap<RecordReference, Entity>();

    public void addChangeValue(ColumnIndex column, Object value) {
        TransactionRecordValue recordValue = new TransactionRecordValue(column, value);
        this.changeMap.put(recordValue.getColumnMappingId(), recordValue);
    }

    public void addRecordReference(RecordReference reference, Entity entity) {
        this.entityByReference.put(reference, entity);
    }

    public Map<RecordReference, Entity> getEntityByReference() {
        return this.entityByReference;
    }

    public TransactionRecordValue getChangeValue(ColumnIndex index) {
        return this.changeMap.get(index.getMappingId());
    }

    public boolean isChanged(ColumnIndex columnIndex) {
        return this.changeMap.containsKey(columnIndex.getMappingId());
    }

    public void setTransactionRecordValues(Transaction transaction, TransactionRecord transactionRecord, boolean strictChangeVerification) {
        ArrayList<AbstractUdbEntity> uncommittedEntityReferences = new ArrayList<AbstractUdbEntity>();
        for (TransactionRecordValue recordValue : this.changeMap.values()) {
            transactionRecord.addRecordValue(recordValue);
            ColumnIndex column = recordValue.getColumn();
            if (recordValue.getValue() == null) continue;
            if (column.getType() == IndexType.MULTI_REFERENCE) {
                Entity entity;
                MultiReferenceEditValue editValue = (MultiReferenceEditValue)recordValue.getValue();
                for (RecordReference recordReference : editValue.getAddReferences()) {
                    entity = this.entityByReference.get(recordReference);
                    if (entity.getId() == 0) {
                        uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                        continue;
                    }
                    if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                    recordReference.setRecordId(entity.getId());
                }
                for (RecordReference recordReference : editValue.getSetReferences()) {
                    entity = this.entityByReference.get(recordReference);
                    if (entity.getId() == 0) {
                        uncommittedEntityReferences.add((AbstractUdbEntity)entity);
                        continue;
                    }
                    if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
                    recordReference.setRecordId(entity.getId());
                }
                continue;
            }
            if (column.getType() != IndexType.REFERENCE) continue;
            RecordReference recordReference = (RecordReference)recordValue.getValue();
            AbstractUdbEntity entity = this.getReferenceChange(column);
            if (entity.getId() == 0) {
                uncommittedEntityReferences.add(entity);
                continue;
            }
            if (recordReference.getRecordId() != 0 || entity.getId() <= 0) continue;
            recordReference.setRecordId(entity.getId());
        }
        for (AbstractUdbEntity entity : uncommittedEntityReferences) {
            TableIndex tableIndex = entity.getTableIndex();
            entity.save(transaction, tableIndex, strictChangeVerification);
        }
    }

    public void setReferenceChange(ColumnIndex index, AbstractUdbEntity reference) {
        this.changedReferenceMap.put(index.getMappingId(), reference);
    }

    public AbstractUdbEntity getReferenceChange(ColumnIndex index) {
        return this.changedReferenceMap.get(index.getMappingId());
    }
}

