/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.translation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.text.CharIndex;
import org.teamapps.universaldb.index.text.CollectionTextSearchIndex;
import org.teamapps.universaldb.index.text.TextSearchIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextFieldFilter;
import org.teamapps.universaldb.index.translation.TranslatableTextFilter;
import org.teamapps.universaldb.transaction.DataType;
import org.teamapps.universaldb.util.DataStreamUtil;

public class TranslatableTextIndex
extends AbstractIndex<TranslatableText, TranslatableTextFilter> {
    private final LongIndex positionIndex;
    private final CharIndex charIndex;
    private final TextSearchIndex searchIndex;
    private final CollectionTextSearchIndex collectionSearchIndex;

    public TranslatableTextIndex(String name, TableIndex table, ColumnType columnType, CollectionTextSearchIndex collectionSearchIndex) {
        super(name, table, columnType, FullTextIndexingOptions.INDEXED);
        this.positionIndex = new LongIndex(name, table, columnType);
        this.charIndex = table.getCollectionCharIndex();
        this.searchIndex = null;
        this.collectionSearchIndex = collectionSearchIndex;
    }

    public TranslatableTextIndex(String name, TableIndex table, ColumnType columnType, boolean withLocalSearchIndex) {
        super(name, table, columnType, withLocalSearchIndex ? FullTextIndexingOptions.INDEXED : FullTextIndexingOptions.NOT_INDEXED);
        this.positionIndex = new LongIndex(name, table, columnType);
        this.charIndex = table.getCollectionCharIndex();
        this.searchIndex = withLocalSearchIndex ? new TextSearchIndex(this.getPath(), name) : null;
        this.collectionSearchIndex = null;
    }

    public CollectionTextSearchIndex getCollectionSearchIndex() {
        return this.collectionSearchIndex;
    }

    public boolean isFilteredByCollectionTextIndex(TranslatableTextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().containsFullTextPart();
    }

    public boolean isFilteredExclusivelyByCollectionTextIndex(TranslatableTextFilter filter) {
        return this.collectionSearchIndex != null && filter.getFilterType().isFullTextIndexExclusive();
    }

    @Override
    public IndexType getType() {
        return IndexType.TRANSLATABLE_TEXT;
    }

    @Override
    public TranslatableText getGenericValue(int id) {
        return this.getValue(id);
    }

    @Override
    public void setGenericValue(int id, TranslatableText value) {
        this.setValue(id, value);
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, null);
    }

    public String getTranslatedValue(int id, String language) {
        TranslatableText value = this.getValue(id);
        return value != null ? value.translationLookup(language) : null;
    }

    public String getTranslatedValue(int id, List<String> languages) {
        TranslatableText value = this.getValue(id);
        return value != null ? value.getTranslation(languages) : null;
    }

    public TranslatableText getValue(int id) {
        long index = this.positionIndex.getValue(id);
        if (index == 0L) {
            return null;
        }
        return new TranslatableText(this.charIndex.getText(index));
    }

    public void setValue(int id, TranslatableText value) {
        String encodedValue;
        long index;
        boolean update = false;
        if (this.searchIndex != null && this.positionIndex.getValue(id) > 0L) {
            update = true;
        }
        if ((index = this.positionIndex.getValue(id)) != 0L) {
            this.charIndex.removeText(index);
        }
        String string = encodedValue = value != null ? value.getEncodedValue() : null;
        if (encodedValue != null) {
            index = this.charIndex.setText(encodedValue);
            this.positionIndex.setValue(id, index);
        } else {
            this.positionIndex.setValue(id, 0L);
        }
        if (this.searchIndex != null) {
            if (!update && encodedValue == null) {
                return;
            }
            this.searchIndex.addValue(id, value, update);
        }
    }

    @Override
    public void writeTransactionValue(TranslatableText value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.STRING.getId());
        value.writeValues(dataOutputStream);
    }

    @Override
    public TranslatableText readTransactionValue(DataInputStream dataInputStream) throws IOException {
        return new TranslatableText(dataInputStream);
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            TranslatableText value = this.getValue(id);
            dataOutputStream.writeInt(id);
            DataStreamUtil.writeTranslatableText(dataOutputStream, value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            TranslatableText value = DataStreamUtil.readTranslatableText(dataInputStream);
            this.setValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, TranslatableTextFilter textFilter) {
        return this.filter(records, textFilter, true);
    }

    @Override
    public void close() {
        if (this.searchIndex != null) {
            this.searchIndex.commit(true);
        }
        this.positionIndex.close();
        this.charIndex.close();
    }

    @Override
    public void drop() {
        if (this.searchIndex != null) {
            this.searchIndex.drop();
        }
        this.positionIndex.drop();
        this.charIndex.drop();
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        String language = locale.getLanguage();
        sortEntries.sort((o1, o2) -> {
            String value1 = this.getTranslatedValue(o1.getLeafId(), language);
            String value2 = this.getTranslatedValue(o2.getLeafId(), language);
            if (value1 == null || value2 == null) {
                if (value1 == null && value2 == null) {
                    return 0;
                }
                if (value1 == null) {
                    return -1 * order;
                }
                return order;
            }
            return value1.compareToIgnoreCase(value2) * order;
        });
        return sortEntries;
    }

    public BitSet filter(BitSet records, TranslatableTextFilter translatableTextFilter, boolean performLocalFullTextSearch) {
        BitSet fullTextResult = records;
        if (performLocalFullTextSearch && translatableTextFilter.getFilterType().containsFullTextPart()) {
            if (this.searchIndex != null) {
                fullTextResult = this.searchIndex.filter(records, translatableTextFilter);
            } else if (this.collectionSearchIndex != null) {
                fullTextResult = this.collectionSearchIndex.filter(records, Collections.emptyList(), Collections.singletonList(TranslatableTextFieldFilter.create(translatableTextFilter, this.getName())), true);
            } else {
                return null;
            }
            if (!translatableTextFilter.getFilterType().containsIndexPart()) {
                return fullTextResult;
            }
        }
        if (translatableTextFilter.getFilterType().containsIndexPart()) {
            switch (translatableTextFilter.getFilterType()) {
                case EMPTY: {
                    return this.filterEmpty(records);
                }
                case NOT_EMPTY: {
                    return this.filterNotEmpty(records);
                }
                case TEXT_EQUALS: {
                    return this.filterEquals(fullTextResult, translatableTextFilter.getValue(), translatableTextFilter.getLanguage());
                }
                case TEXT_NOT_EQUALS: {
                    return this.filterNotEquals(fullTextResult, translatableTextFilter.getValue(), translatableTextFilter.getLanguage());
                }
                case TEXT_BYTE_LENGTH_GREATER: {
                    return this.filterLengthGreater(records, Integer.parseInt(translatableTextFilter.getValue()));
                }
                case TEXT_BYTE_LENGTH_SMALLER: {
                    return this.filterLengthSmaller(records, Integer.parseInt(translatableTextFilter.getValue()));
                }
            }
            return null;
        }
        return null;
    }

    public BitSet filterEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.positionIndex.getValue(id);
            if (index == 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEmpty(BitSet bitSet) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            long index = this.positionIndex.getValue(id);
            if (index != 0L) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthGreater(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int textByteLength;
            long index = this.positionIndex.getValue(id);
            if (index > 0L && (textByteLength = this.charIndex.getTextByteLength(index)) > length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterLengthSmaller(BitSet bitSet, int length) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int textByteLength;
            long index = this.positionIndex.getValue(id);
            if (index > 0L && (textByteLength = this.charIndex.getTextByteLength(index)) < length) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterEquals(BitSet bitSet, String value, String language) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            TranslatableText translatableText = this.getValue(id);
            if (Objects.equals(translatableText.translationLookup(language), value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    private BitSet filterNotEquals(BitSet bitSet, String value, String language) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            TranslatableText translatableText = this.getValue(id);
            if (!Objects.equals(translatableText.translationLookup(language), value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

