/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.cluster.network;

import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    ENCRYPTION_INIT(1),
    ENCRYPTION_INIT_RESPONSE(2),
    INITIAL_MESSAGE(3),
    INITIAL_MESSAGE_RESPONSE(4),
    SCHEMA_UPDATE(5),
    SYNCHRONIZE_TRANSACTIONS_REQUEST(6),
    SYNCHRONIZE_TRANSACTIONS_RESPONSE(7),
    SYNCHRONIZE_TRANSACTIONS_FINISHED(8),
    SYNCHRONIZE_TRANSACTIONS_STATUS(9),
    HEAD_ELECTION_PROPOSAL(10),
    CONNECT_TO_HEAD_REQUEST(11),
    CONNECT_TO_HEAD_WAIT_RESPONSE(12),
    CONNECT_TO_HEAD_SUCCESS_RESPONSE(13),
    CLUSTER_NODE_STATUS_UPDATE(14),
    UNRESOLVED_TRANSACTION(15),
    RESOLVED_TRANSACTION(16),
    CLUSTER_NODE_STATUS_INFO(17);

    private static Map<Integer, MessageType> messageTypeById;
    private final int messageId;

    public static MessageType getById(int messageId) {
        return messageTypeById.get(messageId);
    }

    private MessageType(int messageId) {
        this.messageId = messageId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    static {
        messageTypeById = new HashMap<Integer, MessageType>();
        for (MessageType value : MessageType.values()) {
            messageTypeById.put(value.getMessageId(), value);
        }
    }
}

