/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.multi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceFilterType;
import org.teamapps.universaldb.pojo.Entity;

public class MultiReferenceFilter {
    private final MultiReferenceFilterType type;
    private int countFilter;
    private Set<Integer> referencesSet;

    public static MultiReferenceFilter createEqualsFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.EQUALS, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createNotEqualsFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.NOT_EQUALS, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createIsEmptyFilter() {
        return new MultiReferenceFilter(MultiReferenceFilterType.IS_EMPTY, 0, null);
    }

    public static MultiReferenceFilter createIsNotEmptyFilter() {
        return new MultiReferenceFilter(MultiReferenceFilterType.IS_NOT_EMPTY, 0, null);
    }

    public static MultiReferenceFilter createContainsAllFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ALL, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createContainsAnyFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ANY, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createContainsNotAnyFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ANY_NOT, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createContainsNoneFilter(Collection<? extends Entity> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_NONE, 0, MultiReferenceFilter.createIdSet(references));
    }

    public static MultiReferenceFilter createContainsMoreThanEntriesFilter(int count) {
        return new MultiReferenceFilter(MultiReferenceFilterType.ENTRY_COUNT_GREATER, count, null);
    }

    public static MultiReferenceFilter createContainsLessThanEntriesFilter(int count) {
        return new MultiReferenceFilter(MultiReferenceFilterType.ENTRY_COUNT_LESSER, count, null);
    }

    public static MultiReferenceFilter createIdEqualsFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.EQUALS, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createIdNotEqualsFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.NOT_EQUALS, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createIdContainsAllFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ALL, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createIdContainsAnyFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ANY, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createIdContainsNotAnyFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_ANY_NOT, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createIdContainsNoneFilter(Collection<Integer> references) {
        return new MultiReferenceFilter(MultiReferenceFilterType.CONTAINS_NONE, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createFilter(MultiReferenceFilterType type, Collection<Integer> references) {
        return new MultiReferenceFilter(type, 0, new HashSet<Integer>(references));
    }

    public static MultiReferenceFilter createCountFilter(MultiReferenceFilterType type, int count) {
        return new MultiReferenceFilter(type, count, null);
    }

    private static Set<Integer> createIdSet(Collection<? extends Entity> references) {
        if (references == null || references.isEmpty()) {
            return Collections.emptySet();
        }
        return references.stream().map(entity -> entity.getId()).collect(Collectors.toSet());
    }

    protected MultiReferenceFilter(MultiReferenceFilterType type, int countFilter, Set<Integer> referencesSet) {
        this.type = type;
        this.countFilter = countFilter;
        this.referencesSet = referencesSet;
    }

    public MultiReferenceFilterType getType() {
        return this.type;
    }

    public int getCountFilter() {
        return this.countFilter;
    }

    public Set<Integer> getReferencesSet() {
        return this.referencesSet;
    }

    public String toString() {
        if (this.countFilter > 0) {
            return this.type + ":" + this.countFilter;
        }
        return this.type + ":" + this.referencesSet;
    }
}

