/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.single;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.teamapps.universaldb.index.AbstractBufferIndex;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.FullTextIndexingOptions;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.SortEntry;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.reference.ReferenceIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.value.RecordReference;
import org.teamapps.universaldb.transaction.DataType;

public class SingleReferenceIndex
extends AbstractBufferIndex<RecordReference, NumericFilter>
implements ReferenceIndex {
    public static final int ENTRY_SIZE = 4;
    private TableIndex referencedTable;
    private boolean cyclicReferences;
    private boolean cascadeDeleteReferences;
    private SingleReferenceIndex reverseSingleIndex;
    private MultiReferenceIndex reverseMultiIndex;

    public SingleReferenceIndex(String name, TableIndex tableIndex, ColumnType columnType) {
        super(name, tableIndex, columnType, FullTextIndexingOptions.NOT_INDEXED);
    }

    public void setReferencedTable(TableIndex referencedTable, ColumnIndex reverseIndex, boolean cascadeDeleteReferences) {
        this.referencedTable = referencedTable;
        if (reverseIndex != null) {
            if (reverseIndex instanceof SingleReferenceIndex) {
                this.reverseSingleIndex = (SingleReferenceIndex)reverseIndex;
            } else {
                this.reverseMultiIndex = (MultiReferenceIndex)reverseIndex;
            }
            this.cyclicReferences = true;
        }
        this.cascadeDeleteReferences = cascadeDeleteReferences;
    }

    @Override
    protected int getEntrySize() {
        return 4;
    }

    @Override
    public IndexType getType() {
        return IndexType.REFERENCE;
    }

    @Override
    public TableIndex getReferencedTable() {
        return this.referencedTable;
    }

    @Override
    public boolean isCascadeDeleteReferences() {
        return this.cascadeDeleteReferences;
    }

    @Override
    public ColumnIndex getReferencedColumn() {
        if (this.reverseSingleIndex != null) {
            return this.reverseSingleIndex;
        }
        return this.reverseMultiIndex;
    }

    @Override
    public RecordReference getGenericValue(int id) {
        int value = this.getValue(id);
        if (value == 0) {
            return null;
        }
        return new RecordReference(value, 0);
    }

    @Override
    public void setGenericValue(int id, RecordReference value) {
        if (value == null) {
            this.setValue(id, 0);
        } else {
            this.setValue(id, value.getRecordId());
        }
    }

    @Override
    public void removeValue(int id) {
        this.setValue(id, 0);
    }

    public int getValue(int id) {
        if (id > this.getMaximumId()) {
            return 0;
        }
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 4;
        return this.getBuffer(index).getInt(position, ByteOrder.LITTLE_ENDIAN);
    }

    public void setValue(int id, int value) {
        if (this.cyclicReferences) {
            this.setCyclicReferences(id, value);
        }
        this.setIndexValue(id, value);
    }

    private void setCyclicReferences(int id, int value) {
        int previousValue = this.getValue(id);
        if (previousValue != value) {
            if (this.reverseSingleIndex != null) {
                if (previousValue > 0) {
                    int orphanedReference = this.reverseSingleIndex.getValue(previousValue);
                    assert (orphanedReference > 0);
                    this.setIndexValue(orphanedReference, 0);
                    this.reverseSingleIndex.setIndexValue(previousValue, 0);
                }
                if (value > 0) {
                    this.reverseSingleIndex.setIndexValue(value, id);
                }
            } else {
                if (previousValue > 0) {
                    this.reverseMultiIndex.removeReferences(previousValue, Collections.singletonList(id), true);
                }
                if (value > 0) {
                    this.reverseMultiIndex.addReferences(value, Collections.singletonList(id), true);
                }
            }
        }
    }

    public void setIndexValue(int id, int value) {
        this.ensureBufferSize(id);
        int index = this.getIndexForId(id);
        int offset = this.getOffsetForIndex(index);
        int position = (id - offset) * 4;
        this.getBuffer(index).putInt(position, value, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public List<SortEntry> sortRecords(List<SortEntry> sortEntries, boolean ascending, Locale locale) {
        int order = ascending ? 1 : -1;
        sortEntries.sort((o1, o2) -> {
            int value1 = this.getValue(o1.getLeafId());
            int value2 = this.getValue(o2.getLeafId());
            return Integer.compare(value1, value2) * order;
        });
        return sortEntries;
    }

    @Override
    public void writeTransactionValue(RecordReference value, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getMappingId());
        dataOutputStream.writeByte(DataType.INTEGER.getId());
        if (value == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(value.getRecordId());
            dataOutputStream.writeInt(value.getCorrelationId());
        }
    }

    @Override
    public RecordReference readTransactionValue(DataInputStream dataInputStream) throws IOException {
        int val1 = dataInputStream.readInt();
        if (val1 == 0) {
            return null;
        }
        int val2 = dataInputStream.readInt();
        return new RecordReference(val1, val2);
    }

    @Override
    public void dumpIndex(DataOutputStream dataOutputStream, BitSet records) throws IOException {
        int id = records.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            dataOutputStream.writeInt(id);
            dataOutputStream.writeInt(value);
            id = records.nextSetBit(id + 1);
        }
    }

    @Override
    public void restoreIndex(DataInputStream dataInputStream) throws IOException {
        try {
            int id = dataInputStream.readInt();
            int value = dataInputStream.readInt();
            this.setIndexValue(id, value);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public BitSet filter(BitSet records, NumericFilter numericFilter) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (numericFilter.getValues() != null) {
            for (Number value : numericFilter.getValues()) {
                set.add(value.intValue());
            }
        }
        switch (numericFilter.getFilterType()) {
            case EQUALS: {
                return this.filterEquals(records, numericFilter.getValue1().intValue());
            }
            case NOT_EQUALS: {
                return this.filterNotEquals(records, numericFilter.getValue1().intValue());
            }
            case GREATER: {
                return this.filterGreater(records, numericFilter.getValue1().intValue());
            }
            case GREATER_EQUALS: {
                return this.filterGreaterOrEquals(records, numericFilter.getValue1().intValue());
            }
            case SMALLER: {
                return this.filterSmaller(records, numericFilter.getValue1().intValue());
            }
            case SMALLER_EQUALS: {
                return this.filterSmallerOrEquals(records, numericFilter.getValue1().intValue());
            }
            case BETWEEN: {
                return this.filterBetween(records, numericFilter.getValue1().intValue(), numericFilter.getValue2().intValue());
            }
            case BETWEEN_EXCLUSIVE: {
                return this.filterBetweenExclusive(records, numericFilter.getValue1().intValue(), numericFilter.getValue2().intValue());
            }
            case CONTAINS: {
                return this.filterContains(records, set);
            }
            case CONTAINS_NOT: {
                return this.filterContainsNot(records, set);
            }
        }
        return null;
    }

    public BitSet filterEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value == compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterNotEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value != compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreater(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value > compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterGreaterOrEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value >= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmaller(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value < compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterSmallerOrEquals(BitSet bitSet, int compare) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value <= compare) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetween(BitSet bitSet, int start, int end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value >= start && value <= end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterBetweenExclusive(BitSet bitSet, int start, int end) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (value > start && value < end) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContains(BitSet bitSet, Set<Integer> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }

    public BitSet filterContainsNot(BitSet bitSet, Set<Integer> set) {
        BitSet result = new BitSet();
        int id = bitSet.nextSetBit(0);
        while (id >= 0) {
            int value = this.getValue(id);
            if (!set.contains(value)) {
                result.set(id);
            }
            id = bitSet.nextSetBit(id + 1);
        }
        return result;
    }
}

