/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.index.reference.blockindex;

import org.teamapps.universaldb.index.reference.blockindex.BlockType;
import org.teamapps.universaldb.index.reference.blockindex.ReferenceBuffer;

public class ReferenceBlock {
    private long index;
    private ReferenceBuffer buffer;
    private int blockPosition;
    private BlockType blockType;

    public ReferenceBlock(long index, ReferenceBuffer buffer, int blockPosition, BlockType blockType) {
        this.index = index;
        this.buffer = buffer;
        this.blockPosition = blockPosition;
        this.blockType = blockType;
    }

    public ReferenceBlock(ReferenceBlock block) {
        this.index = block.getIndex();
        this.buffer = block.getBuffer();
        this.blockPosition = block.getBlockPosition();
        this.blockType = block.getBlockType();
    }

    public void reset(long index, ReferenceBuffer buffer, int blockPosition, BlockType blockType) {
        this.index = index;
        this.buffer = buffer;
        this.blockPosition = blockPosition;
        this.blockType = blockType;
    }

    public ReferenceBlock copy() {
        return new ReferenceBlock(this);
    }

    public int getTotalEntryCount() {
        if (this.blockType == BlockType.ENTRIES_4096_START) {
            return this.buffer.readInt(this.blockPosition + 3);
        }
        if (this.blockType.getEntryCountSize() == 0) {
            return this.blockType.getId();
        }
        return this.getBlockEntryCount();
    }

    public int getBlockEntryCount() {
        if (!this.blockType.canContainEmptyEntries()) {
            return this.blockType.getId();
        }
        return this.buffer.readValue(this.blockPosition + 1, this.blockType.getEntryCountSize());
    }

    public int getRemainingEntries() {
        return this.blockType.getMaxEntries() - this.getBlockEntryCount();
    }

    void writeBlockEntryCount(int count) {
        this.buffer.writeValue(count, this.blockPosition + 1, this.blockType.getEntryCountSize());
    }

    void addValue(int value, int entryOffset) {
        this.buffer.writeInt(value, this.blockPosition + this.blockType.getDataOffset() + entryOffset);
    }

    boolean addValueIfRemainingSpace(int value) {
        if (!this.blockType.canContainEmptyEntries()) {
            return false;
        }
        int entries = this.buffer.readValue(this.blockPosition + 1, this.blockType.getEntryCountSize());
        if (this.blockType.getMaxEntries() - entries == 0) {
            return false;
        }
        this.buffer.writeInt(value, this.blockPosition + this.blockType.getDataOffset() + entries * 4);
        this.buffer.writeValue(entries + 1, this.blockPosition + 1, this.blockType.getEntryCountSize());
        return true;
    }

    private byte[] readFullBlockContent() {
        byte[] bytes = new byte[this.blockType.getMaxEntries() * 4];
        this.buffer.readBytes(this.blockPosition + this.blockType.getDataOffset(), bytes);
        return bytes;
    }

    private byte[] readBlockContent(int entries) {
        byte[] bytes = new byte[entries * 4];
        this.buffer.readBytes(this.blockPosition + this.blockType.getDataOffset(), bytes);
        return bytes;
    }

    void copyContent(ReferenceBlock sourceBlock) {
        this.buffer.writeValue(sourceBlock.readFullBlockContent(), this.blockPosition + this.blockType.getDataOffset());
    }

    void copyContent(ReferenceBlock sourceBlock, int entries) {
        this.buffer.writeValue(sourceBlock.readBlockContent(entries), this.blockPosition + this.blockType.getDataOffset());
    }

    void writeStartBlockTotalCount(int count) {
        this.buffer.writeInt(count, this.blockPosition + 3);
    }

    void writeStartBlockNextIndex(long nextIndex) {
        this.buffer.writeLong(nextIndex, this.blockPosition + 7);
    }

    void writeStartBlockLastIndex(long lastIndex) {
        this.buffer.writeLong(lastIndex, this.blockPosition + 15);
    }

    void writeNextIndex(long nextIndex) {
        if (this.blockType == BlockType.ENTRIES_4096_START) {
            this.writeStartBlockNextIndex(nextIndex);
        } else {
            this.buffer.writeLong(nextIndex, this.blockPosition + 3);
        }
    }

    public long getNextIndex() {
        if (this.blockType == BlockType.ENTRIES_4096_START) {
            return this.getStartBlockNextIndex();
        }
        return this.buffer.readLong(this.blockPosition + 3);
    }

    public int getStartBlockTotalCount() {
        return this.buffer.readInt(this.blockPosition + 3);
    }

    public long getStartBlockNextIndex() {
        return this.buffer.readLong(this.blockPosition + 7);
    }

    public long getStartBlockLastIndex() {
        return this.buffer.readLong(this.blockPosition + 15);
    }

    public long getIndex() {
        return this.index;
    }

    public ReferenceBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ReferenceBuffer buffer) {
        this.buffer = buffer;
    }

    public int getBlockPosition() {
        return this.blockPosition;
    }

    public int getBlockDataPosition() {
        return this.blockPosition + this.blockType.getDataOffset();
    }

    public BlockType getBlockType() {
        return this.blockType;
    }
}

