/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.query;

import java.util.BitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.teamapps.universaldb.index.AbstractIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;

public class IndexPath
implements Comparable<IndexPath> {
    private boolean localPath = true;
    private boolean cyclicPath = true;
    private MultiReferenceIndex[] forwardMultiPath;
    private SingleReferenceIndex[] forwardSinglePath;
    private MultiReferenceIndex[] backwardMultiPath;
    private SingleReferenceIndex[] backwardSinglePath;
    private String pathId;

    public IndexPath() {
        this.createPathId();
    }

    public IndexPath copy() {
        IndexPath copy = new IndexPath();
        copy.localPath = this.localPath;
        copy.cyclicPath = this.cyclicPath;
        copy.pathId = this.pathId;
        copy.forwardMultiPath = this.forwardMultiPath;
        copy.forwardSinglePath = this.forwardSinglePath;
        copy.backwardMultiPath = this.backwardMultiPath;
        copy.backwardSinglePath = this.backwardSinglePath;
        return copy;
    }

    public boolean isSamePath(IndexPath path) {
        return this.getPathId().equals(path.getPathId());
    }

    public void addPath(IndexPath path) {
        if (path.isLocalPath()) {
            return;
        }
        SingleReferenceIndex[] forwardSinglePath = path.forwardSinglePath;
        MultiReferenceIndex[] forwardMultiPath = path.forwardMultiPath;
        SingleReferenceIndex[] backwardSinglePath = path.backwardSinglePath;
        MultiReferenceIndex[] backwardMultiPath = path.backwardMultiPath;
        int len = forwardSinglePath.length;
        for (int i = 0; i < len; ++i) {
            if (forwardSinglePath[i] != null) {
                if (backwardSinglePath[i] != null) {
                    this.addPath(forwardSinglePath[i], backwardSinglePath[i]);
                    continue;
                }
                this.addPath(forwardSinglePath[i], backwardMultiPath[i]);
                continue;
            }
            if (backwardSinglePath[i] != null) {
                this.addPath(forwardMultiPath[i], backwardSinglePath[i]);
                continue;
            }
            this.addPath(forwardMultiPath[i], backwardMultiPath[i]);
        }
    }

    public void addPath(MultiReferenceIndex forwardIndex) {
        this.increasePath();
        this.forwardMultiPath[this.forwardMultiPath.length - 1] = forwardIndex;
        this.cyclicPath = false;
        this.createPathId();
    }

    public void addPath(SingleReferenceIndex forwardIndex) {
        this.increasePath();
        this.forwardSinglePath[this.forwardSinglePath.length - 1] = forwardIndex;
        this.cyclicPath = false;
        this.createPathId();
    }

    public void addPath(MultiReferenceIndex forwardIndex, MultiReferenceIndex backwardIndex) {
        this.increasePath();
        this.forwardMultiPath[this.forwardMultiPath.length - 1] = forwardIndex;
        this.backwardMultiPath[0] = backwardIndex;
        this.createPathId();
    }

    public void addPath(MultiReferenceIndex forwardIndex, SingleReferenceIndex backwardIndex) {
        this.increasePath();
        this.forwardMultiPath[this.forwardMultiPath.length - 1] = forwardIndex;
        this.backwardSinglePath[0] = backwardIndex;
        this.createPathId();
    }

    public void addPath(SingleReferenceIndex forwardIndex, MultiReferenceIndex backwardIndex) {
        this.increasePath();
        this.forwardSinglePath[this.forwardSinglePath.length - 1] = forwardIndex;
        this.backwardMultiPath[0] = backwardIndex;
        this.createPathId();
    }

    public void addPath(SingleReferenceIndex forwardIndex, SingleReferenceIndex backwardIndex) {
        this.increasePath();
        this.forwardSinglePath[this.forwardSinglePath.length - 1] = forwardIndex;
        this.backwardSinglePath[0] = backwardIndex;
        this.createPathId();
    }

    public BitSet calculatePathBitSet(BitSet records) {
        if (this.isLocalPath()) {
            return records;
        }
        if (!this.cyclicPath && this.getExpense() > 12) {
            return this.getLeafTable().getRecordBitSet();
        }
        return this.calculatePath(records, false);
    }

    public BitSet calculateReversePath(BitSet records, BitSet originRecords) {
        if (this.isLocalPath()) {
            return records;
        }
        if (!this.cyclicPath || this.getReverseExpense() > 9) {
            return this.calculatePathMath(originRecords, records);
        }
        BitSet localRecords = this.calculatePath(records, true);
        localRecords.and(originRecords);
        return localRecords;
    }

    public int getSinglePathLeafId(int id) {
        if (this.isLocalPath()) {
            return id;
        }
        for (SingleReferenceIndex singleRefIndex : this.forwardSinglePath) {
            if ((id = singleRefIndex.getValue(id)) > 0) continue;
            return 0;
        }
        return id;
    }

    public TableIndex getLeafTable() {
        int length = this.forwardSinglePath.length;
        if (this.forwardSinglePath[length - 1] != null) {
            return this.forwardSinglePath[length - 1].getReferencedTable();
        }
        return this.forwardMultiPath[length - 1].getReferencedTable();
    }

    private BitSet calculatePath(BitSet records, boolean reversePath) {
        if (this.isLocalPath()) {
            return records;
        }
        MultiReferenceIndex[] multiPath = this.forwardMultiPath;
        SingleReferenceIndex[] singlePath = this.forwardSinglePath;
        if (reversePath) {
            multiPath = this.backwardMultiPath;
            singlePath = this.backwardSinglePath;
        }
        int pathLength = multiPath.length;
        BitSet result = new BitSet();
        BitSet bitSet = null;
        for (int i = 0; i < pathLength; ++i) {
            if (bitSet == null) {
                bitSet = records;
            } else {
                bitSet = result;
                result = new BitSet();
            }
            MultiReferenceIndex multiReferenceIndex = multiPath[i];
            if (multiReferenceIndex != null) {
                int id = bitSet.nextSetBit(0);
                while (id >= 0) {
                    BitSet references = multiReferenceIndex.getReferencesAsBitSet(id);
                    result.or(references);
                    id = bitSet.nextSetBit(id + 1);
                }
                continue;
            }
            SingleReferenceIndex singleRefIndex = singlePath[i];
            int id = bitSet.nextSetBit(0);
            while (id >= 0) {
                int value = singleRefIndex.getValue(id);
                if (value > 0) {
                    result.set(value);
                }
                id = bitSet.nextSetBit(id + 1);
            }
        }
        return result;
    }

    private BitSet calculatePathMath(BitSet records, BitSet matchingLeafRecords) {
        BitSet result = new BitSet();
        int maxPos = this.forwardSinglePath.length - 1;
        int id = records.nextSetBit(0);
        while (id >= 0) {
            if (this.isMatch(0, maxPos, id, matchingLeafRecords)) {
                result.set(id);
            }
            id = records.nextSetBit(id + 1);
        }
        return result;
    }

    private boolean isMatch(int pathPos, int maxPos, int id, BitSet matchingLeafRecords) {
        if (pathPos == maxPos) {
            if (this.forwardSinglePath[pathPos] != null) {
                int value = this.forwardSinglePath[pathPos].getValue(id);
                return matchingLeafRecords.get(value);
            }
            PrimitiveIterator.OfInt references = this.forwardMultiPath[pathPos].getReferences(id);
            if (references == null) {
                return false;
            }
            while (references.hasNext()) {
                if (!matchingLeafRecords.get(references.nextInt())) continue;
                return true;
            }
            return false;
        }
        if (this.forwardSinglePath[pathPos] != null) {
            int value = this.forwardSinglePath[pathPos].getValue(id);
            return this.isMatch(pathPos + 1, maxPos, value, matchingLeafRecords);
        }
        PrimitiveIterator.OfInt references = this.forwardMultiPath[pathPos].getReferences(id);
        if (references == null) {
            return false;
        }
        while (references.hasNext()) {
            if (!this.isMatch(pathPos + 1, maxPos, references.nextInt(), matchingLeafRecords)) continue;
            return true;
        }
        return false;
    }

    public boolean isCyclicPath() {
        return !this.localPath && this.cyclicPath;
    }

    public boolean isLocalPath() {
        return this.localPath;
    }

    public String getPathId() {
        return this.pathId;
    }

    public int getExpense() {
        int expense = 0;
        if (this.isLocalPath()) {
            return expense;
        }
        for (MultiReferenceIndex multiReferenceIndex : this.forwardMultiPath) {
            if (multiReferenceIndex != null) {
                expense += 10;
                continue;
            }
            ++expense;
        }
        return expense;
    }

    public int getReverseExpense() {
        int expense = 0;
        if (this.isLocalPath()) {
            return expense;
        }
        for (MultiReferenceIndex multiReferenceIndex : this.backwardMultiPath) {
            if (multiReferenceIndex != null) {
                expense += 10;
                continue;
            }
            ++expense;
        }
        return expense;
    }

    private void createPathId() {
        if (this.isLocalPath()) {
            this.pathId = "empty";
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.forwardMultiPath.length; ++i) {
            MultiReferenceIndex multiReferenceIndex = this.forwardMultiPath[i];
            if (multiReferenceIndex != null) {
                sb.append(multiReferenceIndex.getMappingId()).append(".");
                continue;
            }
            SingleReferenceIndex singleRefIndex = this.forwardSinglePath[i];
            sb.append(singleRefIndex.getMappingId()).append(".");
        }
        this.pathId = sb.toString();
    }

    private void increasePath() {
        this.localPath = false;
        this.forwardMultiPath = this.increasePath(this.forwardMultiPath, false);
        this.forwardSinglePath = this.increasePath(this.forwardSinglePath, false);
        this.backwardMultiPath = this.increasePath(this.backwardMultiPath, true);
        this.backwardSinglePath = this.increasePath(this.backwardSinglePath, true);
    }

    private MultiReferenceIndex[] increasePath(MultiReferenceIndex[] path, boolean reversePath) {
        if (path == null) {
            path = new MultiReferenceIndex[1];
            return path;
        }
        MultiReferenceIndex[] newPath = new MultiReferenceIndex[path.length + 1];
        if (reversePath) {
            System.arraycopy(path, 0, newPath, 1, path.length);
        } else {
            System.arraycopy(path, 0, newPath, 0, path.length);
        }
        return newPath;
    }

    private SingleReferenceIndex[] increasePath(SingleReferenceIndex[] path, boolean reversePath) {
        if (path == null) {
            path = new SingleReferenceIndex[1];
            return path;
        }
        SingleReferenceIndex[] newPath = new SingleReferenceIndex[path.length + 1];
        if (reversePath) {
            System.arraycopy(path, 0, newPath, 1, path.length);
        } else {
            System.arraycopy(path, 0, newPath, 0, path.length);
        }
        return newPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPath path = (IndexPath)o;
        return this.getPathId().equals(path.getPathId());
    }

    public int hashCode() {
        return Objects.hash(this.getPathId());
    }

    @Override
    public int compareTo(IndexPath o) {
        int expense = this.getExpense();
        int otherExpense = o.getExpense();
        return expense - otherExpense;
    }

    public String toString() {
        if (this.isLocalPath()) {
            return "empty";
        }
        StringBuilder sb = new StringBuilder();
        int pathLength = this.forwardSinglePath.length;
        for (int i = 0; i < pathLength; ++i) {
            AbstractIndex index;
            sb.append("->");
            if (this.forwardSinglePath[i] != null) {
                index = this.forwardSinglePath[i];
                sb.append("[").append(((SingleReferenceIndex)index).getReferencedTable().getName()).append("].").append(index.getName());
                continue;
            }
            index = this.forwardMultiPath[i];
            sb.append("[").append(((MultiReferenceIndex)index).getReferencedTable().getName()).append("].").append(index.getName()).append("[mul]");
        }
        return sb.toString();
    }
}

