/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.agrona.concurrent.AtomicBuffer;
import org.teamapps.universaldb.schema.Schema;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.util.MappedStoreUtil;

public class SchemaStats
implements TransactionIdProvider {
    private static final int FIRST_SYSTEM_START_TIMESTAMP_POS = 0;
    private static final int SYSTEM_START_TIMESTAMP_POS = 8;
    private static final int SHUTDOWN_TIMESTAMP_POS = 16;
    private static final int LAST_TRANSACTION_ID_POS = 24;
    private static final int LAST_TRANSACTION_TIMESTAMP_POS = 32;
    private static final int START_UP_COUNT_POS = 40;
    private static final int TRANSACTION_OFFSET_POS = 48;
    private static final int MASTER_TRANSACTION_OFFSET_POS = 56;
    private static final int CLIENT_ID_POS = 100;
    private static final int GROUP_ID_POS = 200;
    private static final int MASTER_CLIENT_ID_POS = 300;
    private static final int MASTER_GROUP_ID_POS = 400;
    private static final int SCHEMA_POS = 500;
    private final File path;
    private AtomicBuffer buffer;
    private Schema schema;
    private final String clientId;
    private final String groupId;
    private final String masterClientId;
    private final String masterGroupId;
    private long startupCount;

    public SchemaStats(File path) {
        this.path = path;
        File file = new File(this.path, "database.stat");
        this.buffer = MappedStoreUtil.createAtomicBuffer(file, 500000);
        if (this.readLong(0) == 0L) {
            this.writeLong(0, System.currentTimeMillis());
        }
        this.writeLong(8, System.currentTimeMillis());
        if (this.readInt(100) == 0) {
            this.clientId = UUID.randomUUID().toString().replace("-", "");
            this.groupId = UUID.randomUUID().toString().replace("-", "");
            this.masterClientId = UUID.randomUUID().toString().replace("-", "");
            this.masterGroupId = UUID.randomUUID().toString().replace("-", "");
            this.writeString(100, this.clientId);
            this.writeString(200, this.groupId);
            this.writeString(300, this.masterClientId);
            this.writeString(400, this.masterGroupId);
        } else {
            this.clientId = this.readString(100);
            this.groupId = this.readString(200);
            this.masterClientId = this.readString(300);
            this.masterGroupId = this.readString(400);
        }
        this.startupCount = this.readLong(40) + 1L;
        this.writeLong(40, this.startupCount);
    }

    public Schema loadSchema() throws IOException {
        int len = this.buffer.getInt(500);
        if (len == 0) {
            return null;
        }
        byte[] bytes = new byte[len];
        this.buffer.getBytes(504, bytes);
        return new Schema(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void saveSchema(Schema schema) throws IOException {
        byte[] bytes = schema.getSchemaData();
        this.buffer.putInt(500, bytes.length);
        this.buffer.putBytes(504, bytes);
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getMasterClientId() {
        return this.masterClientId;
    }

    public String getMasterGroupId() {
        return this.masterGroupId;
    }

    public long getStartupCount() {
        return this.startupCount;
    }

    public long getFirstSystemStartTimestamp() {
        return this.readLong(0);
    }

    public long getLastTransactionId() {
        return this.readLong(24);
    }

    public long setNextTransactionId() {
        long transactionId = this.getLastTransactionId();
        this.writeLong(24, ++transactionId);
        this.writeLong(32, System.currentTimeMillis());
        return transactionId;
    }

    public long getLastTransactionTimestamp() {
        return this.readLong(32);
    }

    public long getTransactionOffset() {
        return this.readLong(48);
    }

    public void setTransactionOffset(long transactionOffset) {
        this.writeLong(48, transactionOffset);
    }

    public long getMasterTransactionOffset() {
        return this.readLong(56);
    }

    public void setMasterTransactionOffset(long masterTransactionOffset) {
        this.writeLong(56, masterTransactionOffset);
    }

    private long readLong(int pos) {
        return this.buffer.getLongVolatile(pos);
    }

    private void writeLong(int pos, long value) {
        this.buffer.putLongVolatile(pos, value);
    }

    private int readInt(int pos) {
        return this.buffer.getIntVolatile(pos);
    }

    private void writeInt(int pos, int value) {
        this.buffer.putIntVolatile(pos, value);
    }

    private String readString(int pos) {
        int length = this.buffer.getIntVolatile(pos);
        byte[] bytes = new byte[length];
        this.buffer.getBytes(pos + 4, bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private void writeString(int pos, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.buffer.putIntVolatile(pos, bytes.length);
        this.buffer.putBytes(pos + 4, bytes);
    }

    @Override
    public long getLastCommittedTransactionId() {
        return this.getLastTransactionId();
    }

    @Override
    public long getNextTransactionId() {
        return this.setNextTransactionId();
    }
}

