/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.SchemaStats;
import org.teamapps.universaldb.distribute.ClusterSetConfig;
import org.teamapps.universaldb.distribute.PacketDataMingling;
import org.teamapps.universaldb.distribute.TransactionMessageKey;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionMaster
implements LeaderSelectorListener,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LEADER_SELECTION_NODE = "/leaderSelection/leader";
    private final String clientId;
    private final String sharedSecret;
    private final SchemaStats schemaStats;
    private final DataBaseMapper dataBaseMapper;
    private final TransactionIdProvider transactionIdProvider;
    private final Consumer<byte[], byte[]> consumer;
    private final KafkaProducer<byte[], byte[]> producer;
    private final LeaderSelector leaderSelector;
    private final String consumerTopic;
    private final TopicPartition consumerTopicPartition;
    private final String producerTopic;
    private boolean masterRole;
    private final String masterProducerClientId;
    private long packetKey;

    public TransactionMaster(ClusterSetConfig clusterConfig, SchemaStats schemaStats, DataBaseMapper dataBaseMapper, TransactionIdProvider transactionIdProvider) {
        this.clientId = schemaStats.getClientId();
        this.sharedSecret = clusterConfig.getSharedSecret();
        this.schemaStats = schemaStats;
        this.dataBaseMapper = dataBaseMapper;
        this.transactionIdProvider = transactionIdProvider;
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", clusterConfig.getKafkaConfig());
        consumerProps.put("group.id", schemaStats.getMasterGroupId());
        consumerProps.put("group.instance.id", schemaStats.getMasterGroupId());
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("max.poll.records", (Object)10000);
        consumerProps.put("enable.auto.commit", "true");
        consumerProps.put("auto.offset.reset", "earliest");
        this.consumerTopic = clusterConfig.getTopicPrefix() + "-unresolved";
        this.consumerTopicPartition = new TopicPartition(this.consumerTopic, 0);
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumer.subscribe(Collections.singletonList(this.consumerTopic));
        this.masterProducerClientId = schemaStats.getMasterClientId();
        this.producerTopic = clusterConfig.getTopicPrefix() + "-resolved";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", clusterConfig.getKafkaConfig());
        producerProps.put("client.id", this.clientId);
        producerProps.put("key.serializer", ByteArraySerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        this.producer = new KafkaProducer(producerProps);
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)clusterConfig.getZookeeperConfig(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.leaderSelector = new LeaderSelector(client, LEADER_SELECTION_NODE, (LeaderSelectorListener)this);
        client.start();
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
    }

    public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
        if (!connectionState.isConnected()) {
            this.masterRole = false;
        }
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        logger.info("START TRANSACTION MASTER");
        this.masterRole = true;
        while (this.masterRole) {
            this.handleMessages();
        }
        logger.info("END TRANSACTION MASTER");
    }

    private void handleMessages() throws IOException {
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofSeconds(1L));
        List records = consumerRecords.records(this.consumerTopicPartition);
        for (ConsumerRecord record : records) {
            TransactionMessageKey messageKey = new TransactionMessageKey((byte[])record.key());
            byte[] value = (byte[])record.value();
            byte[] bytes = PacketDataMingling.mingle(value, this.sharedSecret, messageKey.getLocalKey());
            System.out.println("MASTER received bytes enc:" + Base64.getEncoder().encodeToString(value));
            System.out.println("MASTER received bytes raw:" + Base64.getEncoder().encodeToString(bytes));
            logger.info("MASTER received new transaction:" + messageKey);
            TransactionPacket transactionPacket = new TransactionPacket(bytes);
            ClusterTransaction transaction = new ClusterTransaction(transactionPacket, this.dataBaseMapper);
            TransactionMessageKey masterMessageKey = new TransactionMessageKey(messageKey.getMessageType(), messageKey.getClientId(), this.getNextKey());
            masterMessageKey.setMasterClientId(this.masterProducerClientId);
            transactionPacket = transaction.resolveAndExecuteTransaction(this.transactionIdProvider, transactionPacket);
            if (transactionPacket != null) {
                logger.info("MASTER send new transaction:" + masterMessageKey);
                byte[] packetBytes = transactionPacket.writePacketBytes();
                byte[] mingledBytes = PacketDataMingling.mingle(packetBytes, this.sharedSecret, masterMessageKey.getLocalKey());
                this.producer.send(new ProducerRecord(this.producerTopic, (Object)masterMessageKey.getBytes(), (Object)mingledBytes));
                continue;
            }
            logger.info("Sending error packet...");
            this.producer.send(new ProducerRecord(this.producerTopic, (Object)masterMessageKey.getBytes(), null));
        }
    }

    @Override
    public void close() throws IOException {
        this.leaderSelector.close();
    }

    private long getNextKey() {
        return ++this.packetKey;
    }
}

