/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.teamapps.universaldb.distribute.TransactionMessageType;
import org.teamapps.universaldb.util.DataStreamUtil;

public class TransactionMessageKey {
    private final TransactionMessageType messageType;
    private final String clientId;
    private final long localKey;
    private String masterClientId;
    private long masterOffset;

    public TransactionMessageKey(TransactionMessageType messageType, String clientId, long localKey) {
        this.messageType = messageType;
        this.clientId = clientId;
        this.localKey = localKey;
    }

    public TransactionMessageKey(byte[] bytes) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        this.messageType = TransactionMessageType.values()[dataInputStream.readInt()];
        this.clientId = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.localKey = dataInputStream.readLong();
        this.masterClientId = DataStreamUtil.readStringWithLengthHeader(dataInputStream);
        this.masterOffset = dataInputStream.readLong();
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.messageType.ordinal());
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.clientId);
        dataOutputStream.writeLong(this.localKey);
        DataStreamUtil.writeStringWithLengthHeader(dataOutputStream, this.masterClientId);
        dataOutputStream.writeLong(this.masterOffset);
        return byteArrayOutputStream.toByteArray();
    }

    public TransactionMessageType getMessageType() {
        return this.messageType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getLocalKey() {
        return this.localKey;
    }

    public String getMasterClientId() {
        return this.masterClientId;
    }

    public void setMasterClientId(String masterClientId) {
        this.masterClientId = masterClientId;
    }

    public long getMasterOffset() {
        return this.masterOffset;
    }

    public void setMasterOffset(long masterOffset) {
        this.masterOffset = masterOffset;
    }

    public String toString() {
        return "TransactionMessageKey{messageType=" + this.messageType + ", clientId='" + this.clientId + "', localKey=" + this.localKey + ", masterClientId='" + this.masterClientId + "', masterOffset=" + this.masterOffset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionMessageKey that = (TransactionMessageKey)o;
        return this.localKey == that.localKey && this.messageType == that.messageType && this.clientId.equals(that.clientId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.clientId, this.localKey});
    }
}

