/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.SchemaStats;
import org.teamapps.universaldb.distribute.ClusterSetConfig;
import org.teamapps.universaldb.distribute.PacketDataMingling;
import org.teamapps.universaldb.distribute.TransactionExecutionResult;
import org.teamapps.universaldb.distribute.TransactionMessageKey;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionIdProvider;
import org.teamapps.universaldb.transaction.TransactionPacket;

public class TransactionReader {
    public static final String RESOLVED_SUFFIX = "resolved";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String masterProducerClientId;
    private final String sharedSecret;
    private final SchemaStats schemaStats;
    private final DataBaseMapper dataBaseMapper;
    private final Consumer<byte[], byte[]> consumer;
    private final String topic;
    private final TopicPartition topicPartition;
    private final Map<TransactionMessageKey, TransactionExecutionResult> transactionMap;
    private final TransactionIdProvider transactionIdProvider;

    public TransactionReader(ClusterSetConfig clusterConfig, SchemaStats schemaStats, DataBaseMapper dataBaseMapper, Map<TransactionMessageKey, TransactionExecutionResult> transactionMap, TransactionIdProvider transactionIdProvider) {
        this.sharedSecret = clusterConfig.getSharedSecret();
        this.schemaStats = schemaStats;
        this.dataBaseMapper = dataBaseMapper;
        this.transactionMap = transactionMap;
        this.transactionIdProvider = transactionIdProvider;
        this.masterProducerClientId = schemaStats.getMasterClientId();
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", clusterConfig.getKafkaConfig());
        consumerProps.put("group.id", schemaStats.getMasterGroupId());
        consumerProps.put("group.instance.id", schemaStats.getMasterGroupId());
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("max.poll.records", (Object)10000);
        consumerProps.put("enable.auto.commit", "true");
        consumerProps.put("auto.offset.reset", "earliest");
        this.topic = clusterConfig.getTopicPrefix() + "-resolved";
        this.topicPartition = new TopicPartition(this.topic, 0);
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumer.subscribe(Collections.singletonList(this.topic));
        new Thread(() -> this.start()).start();
    }

    private void start() {
        while (true) {
            try {
                while (true) {
                    this.consume();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void consume() throws IOException {
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofSeconds(1L));
        List records = consumerRecords.records(this.topicPartition);
        for (ConsumerRecord record : records) {
            TransactionMessageKey messageKey = new TransactionMessageKey((byte[])record.key());
            byte[] value = (byte[])record.value();
            System.out.println("Received bytes enc:" + Base64.getEncoder().encodeToString(value));
            byte[] bytes = PacketDataMingling.mingle(value, this.sharedSecret, messageKey.getLocalKey());
            System.out.println("Received bytes raw:" + Base64.getEncoder().encodeToString(bytes));
            TransactionPacket transactionPacket = new TransactionPacket(bytes);
            ClusterTransaction transaction = new ClusterTransaction(transactionPacket, this.dataBaseMapper);
            logger.info("Client reader - received new transaction:" + messageKey);
            if (messageKey.getClientId().equals(this.masterProducerClientId)) {
                TransactionExecutionResult executionResult = this.transactionMap.remove(messageKey);
                if (executionResult == null) continue;
                if (value != null) {
                    executionResult.handleSuccess(transaction.getRecordIdByCorrelationId());
                    continue;
                }
                executionResult.handleError();
                continue;
            }
            if (transaction.getTransactionId() == this.transactionIdProvider.getLastCommittedTransactionId() + 1L) {
                transaction.executeResolvedTransaction();
                continue;
            }
            logger.warn("Transaction with wrong transaction id! Expected id:" + (this.transactionIdProvider.getLastCommittedTransactionId() + 1L) + ", actual id:" + transaction.getTransactionId() + ", key:");
        }
    }
}

