/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.distribute;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.SchemaStats;
import org.teamapps.universaldb.distribute.ClusterSetConfig;
import org.teamapps.universaldb.distribute.PacketDataMingling;
import org.teamapps.universaldb.distribute.TransactionExecutionResult;
import org.teamapps.universaldb.distribute.TransactionMessageKey;
import org.teamapps.universaldb.distribute.TransactionMessageType;
import org.teamapps.universaldb.transaction.ClusterTransaction;
import org.teamapps.universaldb.transaction.TransactionPacket;
import org.teamapps.universaldb.transaction.TransactionRequest;

public class TransactionWriter
implements Callback {
    public static final String UNRESOLVED_SUFFIX = "unresolved";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final KafkaProducer<byte[], byte[]> producer;
    private final String clientId;
    private final String sharedSecret;
    private final String topic;
    private final SchemaStats schemaStats;
    private long packetKey;
    private final Map<TransactionMessageKey, TransactionExecutionResult> transactionMap = new ConcurrentHashMap<TransactionMessageKey, TransactionExecutionResult>();

    public TransactionWriter(ClusterSetConfig clusterConfig, SchemaStats schemaStats) {
        this.clientId = schemaStats.getClientId();
        this.sharedSecret = clusterConfig.getSharedSecret();
        this.topic = clusterConfig.getTopicPrefix() + "-unresolved";
        this.schemaStats = schemaStats;
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", clusterConfig.getKafkaConfig());
        producerProps.put("client.id", this.clientId);
        producerProps.put("key.serializer", ByteArraySerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        this.producer = new KafkaProducer(producerProps);
    }

    public TransactionExecutionResult writeTransaction(ClusterTransaction transaction) throws IOException {
        TransactionRequest request = transaction.createRequest();
        TransactionPacket packet = request.getPacket();
        long key = this.getNextKey();
        byte[] packetBytes = packet.writePacketBytes();
        System.out.println("Send bytes raw:" + Base64.getEncoder().encodeToString(packetBytes));
        byte[] bytes = PacketDataMingling.mingle(packetBytes, this.sharedSecret, key);
        System.out.println("Send bytes end:" + Base64.getEncoder().encodeToString(bytes));
        TransactionMessageKey messageKey = new TransactionMessageKey(TransactionMessageType.TRANSACTION, this.clientId, key);
        TransactionExecutionResult result = new TransactionExecutionResult();
        this.transactionMap.put(messageKey, result);
        this.producer.send(new ProducerRecord(this.topic, (Object)messageKey.getBytes(), (Object)bytes), (Callback)this);
        logger.info("Client writer - sent transaction:" + messageKey);
        return result;
    }

    private long getNextKey() {
        return ++this.packetKey;
    }

    public Map<TransactionMessageKey, TransactionExecutionResult> getTransactionMap() {
        return this.transactionMap;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
    }
}

