/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.universaldb.transaction;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.universaldb.TableConfig;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.DataBaseMapper;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.text.FullTextIndexValue;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.transaction.TransactionRecordValue;

public class TransactionRecord {
    private static final Logger log = LoggerFactory.getLogger(TransactionRecord.class);
    private final TableIndex tableIndex;
    private int recordId;
    private final boolean update;
    private final boolean deleteRecord;
    private final int correlationId;
    private final long recordTransactionId;
    private List<TransactionRecordValue> recordValues;
    private boolean transactionProcessingStarted = false;

    public TransactionRecord(TableIndex tableIndex, int recordId, int correlationId, int userId) {
        this(tableIndex, recordId, correlationId, userId, recordId > 0, false, false);
    }

    public TransactionRecord(TableIndex tableIndex, int recordId, int correlationId, int userId, boolean deleteRecord) {
        this(tableIndex, recordId, correlationId, userId, deleteRecord, recordId > 0, false);
    }

    public TransactionRecord(TableIndex tableIndex, int recordId, int correlationId, int userId, boolean update, boolean deleteRecord, boolean strictChangeVerification) {
        this.tableIndex = tableIndex;
        this.recordId = recordId;
        this.correlationId = correlationId;
        this.update = update;
        this.deleteRecord = deleteRecord;
        this.recordTransactionId = strictChangeVerification ? tableIndex.getTransactionId(recordId) : 0L;
        TableConfig config = tableIndex.getTableConfig();
        this.recordValues = new ArrayList<TransactionRecordValue>();
        if (deleteRecord) {
            if (recordId <= 0) {
                throw new RuntimeException("Cannot delete record with no record id");
            }
            this.setDeletionData(tableIndex, userId);
        } else {
            this.setModificationData(tableIndex, update, userId);
        }
    }

    public void setModificationData(TableIndex tableIndex, boolean update, int userId) {
        TableConfig config = tableIndex.getTableConfig();
        if (!update) {
            if (config.trackCreation()) {
                this.addRecordValue(tableIndex.getColumnIndex("metaCreationDate"), (int)(System.currentTimeMillis() / 1000L));
                this.addRecordValue(tableIndex.getColumnIndex("metaCreatedBy"), userId);
            }
        } else if (config.trackModification()) {
            this.addRecordValue(tableIndex.getColumnIndex("metaModificationDate"), (int)(System.currentTimeMillis() / 1000L));
            this.addRecordValue(tableIndex.getColumnIndex("metaModifiedBy"), userId);
        }
    }

    public void setDeletionData(TableIndex tableIndex, int userId) {
        TableConfig config = tableIndex.getTableConfig();
        if (config.keepDeleted()) {
            this.addRecordValue(tableIndex.getColumnIndex("metaDeletionDate"), (int)(System.currentTimeMillis() / 1000L));
            this.addRecordValue(tableIndex.getColumnIndex("metaDeletedBy"), userId);
        }
    }

    public TransactionRecord(DataInputStream dataInputStream, DataBaseMapper dataBaseMapper) throws IOException {
        this.tableIndex = dataBaseMapper.getCollectionIndexById(dataInputStream.readInt());
        this.recordId = dataInputStream.readInt();
        this.correlationId = dataInputStream.readInt();
        this.update = dataInputStream.readBoolean();
        this.deleteRecord = dataInputStream.readBoolean();
        this.recordTransactionId = dataInputStream.readLong();
        this.recordValues = new ArrayList<TransactionRecordValue>();
        int valueCount = dataInputStream.readInt();
        for (int i = 0; i < valueCount; ++i) {
            this.recordValues.add(new TransactionRecordValue(dataInputStream, dataBaseMapper));
        }
    }

    public void addRecordValue(ColumnIndex column, Object value) {
        this.addRecordValue(new TransactionRecordValue(column, value));
    }

    public void addRecordValue(TransactionRecordValue recordValue) {
        this.recordValues.add(recordValue);
    }

    public int getRecordId() {
        return this.recordId;
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public List<TransactionRecordValue> getRecordValues() {
        return this.recordValues;
    }

    public void writeTransactionValue(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.tableIndex.getMappingId());
        dataOutputStream.writeInt(this.recordId);
        dataOutputStream.writeInt(this.correlationId);
        dataOutputStream.writeBoolean(this.update);
        dataOutputStream.writeBoolean(this.deleteRecord);
        dataOutputStream.writeLong(this.recordTransactionId);
        dataOutputStream.writeInt(this.recordValues.size());
        for (TransactionRecordValue recordValue : this.recordValues) {
            recordValue.writeTransactionValue(dataOutputStream);
        }
    }

    public boolean checkUnchangedRecordTransactionId() {
        if (this.recordTransactionId == 0L || this.recordId == 0) {
            return true;
        }
        return this.recordTransactionId == this.tableIndex.getTransactionId(this.recordId);
    }

    public void createIfNotExists(Map<Integer, Integer> recordIdByCorrelationId) {
        if (!this.deleteRecord) {
            boolean updateMap = this.recordId == 0;
            this.recordId = this.tableIndex.createRecord(this.recordId, this.correlationId, this.update);
            if (updateMap) {
                recordIdByCorrelationId.put(this.correlationId, this.recordId);
            }
        }
    }

    public void persistChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        if (this.transactionProcessingStarted) {
            return;
        }
        this.transactionProcessingStarted = true;
        boolean processChanges = true;
        if (this.deleteRecord) {
            processChanges = this.tableIndex.deleteRecord(this.recordId);
        } else if (this.recordId == 0) {
            log.error("ERROR!: could not save record - record id == 0:" + this.tableIndex.getFQN());
            return;
        }
        if (processChanges) {
            this.processColumnChanges(transactionId, recordIdByCorrelationId);
        }
    }

    public void persistResolvedChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        boolean processChanges = true;
        if (this.deleteRecord) {
            processChanges = this.tableIndex.deleteRecord(this.recordId);
        } else {
            if (this.recordId == 0) {
                this.recordId = recordIdByCorrelationId.get(this.correlationId);
                if (this.recordId == 0) {
                    log.error("ERROR!: could not resolve recordId by correlationId for table:" + this.tableIndex.getFQN());
                    return;
                }
            }
            this.recordId = this.tableIndex.createRecord(this.recordId, this.correlationId, this.update);
        }
        if (processChanges) {
            this.processColumnChanges(transactionId, recordIdByCorrelationId);
        }
    }

    public void processColumnChanges(long transactionId, Map<Integer, Integer> recordIdByCorrelationId) {
        List<FullTextIndexValue> fullTextIndexValues;
        this.tableIndex.setTransactionId(this.recordId, transactionId);
        for (TransactionRecordValue recordValue : this.recordValues) {
            recordValue.persistChange(this.recordId, recordIdByCorrelationId);
        }
        if (!this.deleteRecord && !(fullTextIndexValues = this.recordValues.stream().filter(value -> value.getColumn().getType() == IndexType.TEXT || value.getColumn().getType() == IndexType.TRANSLATABLE_TEXT).map(value -> {
            if (value.getColumn().getType() == IndexType.TEXT) {
                return new FullTextIndexValue(value.getColumn().getName(), (String)value.getValue());
            }
            return new FullTextIndexValue(value.getColumn().getName(), (TranslatableText)value.getValue());
        }).collect(Collectors.toList())).isEmpty()) {
            this.tableIndex.updateFullTextIndex(this.recordId, fullTextIndexValues, this.update);
        }
    }
}

